/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.editelement;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.TextElementData;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TextElementDataInput
extends JPanel {
    private JTextField textField;
    private JCheckBox decimalCheckBox;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public TextElementDataInput(boolean horizontalLayout) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWeights = new double[]{1.0, 0.0};
        this.setLayout(gridBagLayout);
        GridBagConstraints gbc_textField = new GridBagConstraints();
        gbc_textField.insets = new Insets(0, 0, 0, 3);
        gbc_textField.fill = 2;
        gbc_textField.gridx = 0;
        gbc_textField.gridy = 0;
        this.add((Component)this.getTextField(), gbc_textField);
        GridBagConstraints gbc_decimalCheckBox = new GridBagConstraints();
        gbc_decimalCheckBox.anchor = 17;
        if (horizontalLayout) {
            gbc_decimalCheckBox.gridx = 1;
            gbc_decimalCheckBox.gridy = 0;
        } else {
            gbc_decimalCheckBox.gridx = 0;
            gbc_decimalCheckBox.gridy = 1;
        }
        this.add((Component)this.getDecimalCheckBox(), gbc_decimalCheckBox);
    }

    private JCheckBox getDecimalCheckBox() {
        if (this.decimalCheckBox == null) {
            this.decimalCheckBox = new JCheckBox("Decimal value");
            this.decimalCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TextElementDataInput.this.fireValueChanged();
                }
            });
        }
        return this.decimalCheckBox;
    }

    private JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField();
            this.textField.setColumns(10);
            this.textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    TextElementDataInput.this.setDecimalCheckBoxStatus();
                    TextElementDataInput.this.fireValueChanged();
                }
            });
        }
        return this.textField;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getTextField().setEnabled(enabled);
        if (enabled) {
            this.setDecimalCheckBoxStatus();
        } else {
            this.getDecimalCheckBox().setEnabled(false);
        }
        super.setEnabled(enabled);
    }

    private void setDecimalCheckBoxStatus() {
        boolean isDecimal = Math2.isDecimal(this.getTextField().getText());
        if (!isDecimal) {
            this.getDecimalCheckBox().setSelected(false);
        }
        this.getDecimalCheckBox().setEnabled(isDecimal);
    }

    public TextElementData getValue() {
        if (this.getDecimalCheckBox().isSelected()) {
            if (this.getTextField().getText().isEmpty()) {
                return new TextElementData();
            }
            return new TextElementData(Math2.parseDouble(this.getTextField().getText()));
        }
        return new TextElementData(this.getTextField().getText());
    }

    public void setValue(TextElementData data) {
        this.getTextField().setText(data.toString());
        this.getDecimalCheckBox().setSelected(data.isDecimal());
    }

    protected void fireValueChanged() {
        ChangeEvent event = new ChangeEvent(this.getValue());
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(event);
        }
    }

    public void addValueChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public boolean removeValueChangeListener(ChangeListener listener) {
        return this.changeListeners.remove(listener);
    }
}

