/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.editelement;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.TextLabel;
import info.bioinfweb.treegraph.document.format.FormatUtils;
import info.bioinfweb.treegraph.document.undo.edit.InsertLabelEdit;
import info.bioinfweb.treegraph.gui.dialogs.CollidingIDsDialog;
import info.bioinfweb.treegraph.gui.dialogs.DataIDComboBox;
import info.bioinfweb.treegraph.gui.dialogs.editelement.AbstractTextElementDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class NewTextLabelDialog
extends AbstractTextElementDialog {
    private JPanel jContentPane = null;
    private JPanel idPanel = null;
    private DataIDComboBox idComboBox = null;

    public NewTextLabelDialog(Frame owner) {
        super(owner);
        this.setHelpCode(15);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    @Override
    protected boolean onExecute() {
        boolean result;
        Branch b = this.getSelection().getFirstElementOfType(Branch.class);
        boolean bl = result = b != null;
        if (result) {
            this.setTextElement(new TextLabel(b.getLabels()));
            this.getIDComboBox().setIDs(this.getDocument());
        }
        return result;
    }

    protected boolean apply() {
        TextLabel label = (TextLabel)this.getTextElement();
        if (this.getDecimalCheckBox().isSelected()) {
            label.getData().setDecimal(Math2.parseDouble(this.getValueTextField().getText()));
        } else {
            label.getData().setText(this.getValueTextField().getText());
        }
        if (this.getIDComboBox().getSelectedItem() == null || this.getIDComboBox().getSelectedItem().equals("")) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You have to specify an ID.", "Error", 0);
            return false;
        }
        Branch branch = this.getSelection().getFirstElementOfType(Branch.class);
        label.setID(CollidingIDsDialog.getInstance().checkConflicts(new Branch[]{branch}, this.getIDComboBox().getSelectedItem()));
        label.getFormats().setTextColor(FormatUtils.getTextColor(this.getDocument()));
        this.getDocument().executeEdit(new InsertLabelEdit(this.getDocument(), label, branch.getLabels()));
        return true;
    }

    private void initialize() {
        this.setTitle("New text label");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getValuesPanel(), null);
            this.jContentPane.add((Component)this.getPreviewPanel(), null);
            this.jContentPane.add((Component)this.getIDPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getIDPanel() {
        if (this.idPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.gridx = 0;
            this.idPanel = new JPanel();
            this.idPanel.setLayout(new GridBagLayout());
            this.idPanel.add((Component)this.getIDComboBox(), gridBagConstraints);
            this.idPanel.setBorder(BorderFactory.createTitledBorder(null, "ID", 0, 0, null, null));
        }
        return this.idPanel;
    }

    private DataIDComboBox getIDComboBox() {
        if (this.idComboBox == null) {
            this.idComboBox = new DataIDComboBox(true);
        }
        return this.idComboBox;
    }
}

