/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.editelement;

import info.bioinfweb.treegraph.document.PieChartLabel;
import info.bioinfweb.treegraph.gui.dialogs.editelement.NewGraphicalLabelsDialog;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.PieChartSectionDataList;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class NewPieChartLabelsDialog
extends NewGraphicalLabelsDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private PieChartSectionDataList valuesPanel = null;
    private JTextField titleTextField;
    private JPanel titlePanel;

    public NewPieChartLabelsDialog(Frame owner) {
        super(owner);
        this.setHelpCode(91);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    @Override
    protected boolean onExecute() {
        boolean result = super.onExecute();
        if (result) {
            this.getValuesPanel().setIDs(this.getDocument());
        }
        return result;
    }

    @Override
    protected PieChartLabel createLabel() {
        PieChartLabel label = new PieChartLabel(null);
        label.getData().setText(this.getTitleTextField().getText());
        label.getSectionDataList().addAll(this.getValuesPanel().getSectionDataList());
        return label;
    }

    private void initialize() {
        this.setTitle("New pie chart label(s)");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getIDPanel(), null);
            this.jContentPane.add(this.getTitlePanel());
            this.jContentPane.add((Component)this.getValuesPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JTextField getTitleTextField() {
        if (this.titleTextField == null) {
            this.titleTextField = new JTextField();
            this.titleTextField.setColumns(10);
        }
        return this.titleTextField;
    }

    protected PieChartSectionDataList getValuesPanel() {
        if (this.valuesPanel == null) {
            this.valuesPanel = new PieChartSectionDataList();
            this.valuesPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Pie chart value IDs", 4, 2, null, null));
        }
        return this.valuesPanel;
    }

    protected JPanel getTitlePanel() {
        if (this.titlePanel == null) {
            this.titlePanel = new JPanel();
            this.titlePanel.setBorder(new TitledBorder(null, "Chart title", 4, 2, null, null));
            GridBagLayout gbl_titlePanel = new GridBagLayout();
            this.titlePanel.setLayout(gbl_titlePanel);
            GridBagConstraints gbc_titleTextField = new GridBagConstraints();
            gbc_titleTextField.weightx = 1.0;
            gbc_titleTextField.fill = 2;
            gbc_titleTextField.anchor = 11;
            gbc_titleTextField.gridx = 0;
            gbc_titleTextField.gridy = 0;
            this.titlePanel.add((Component)this.getTitleTextField(), gbc_titleTextField);
        }
        return this.titlePanel;
    }
}

