/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.editelement;

import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.GraphicalLabel;
import info.bioinfweb.treegraph.document.format.FormatUtils;
import info.bioinfweb.treegraph.document.format.GraphicalLabelFormats;
import info.bioinfweb.treegraph.document.undo.edit.InsertLabelsEdit;
import info.bioinfweb.treegraph.gui.dialogs.CollidingIDsDialog;
import info.bioinfweb.treegraph.gui.dialogs.DataIDComboBox;
import info.bioinfweb.treegraph.gui.dialogs.EditDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public abstract class NewGraphicalLabelsDialog
extends EditDialog {
    private static final long serialVersionUID = 1L;
    private JPanel idPanel = null;
    private DataIDComboBox idComboBox = null;

    public NewGraphicalLabelsDialog(Frame owner) {
        super(owner);
    }

    @Override
    protected boolean onExecute() {
        boolean result = this.getSelection().containsType(Branch.class);
        if (result) {
            this.getIDComboBox().setIDs(this.getDocument());
        }
        return true;
    }

    protected abstract GraphicalLabel createLabel();

    protected boolean apply() {
        GraphicalLabel label = this.createLabel();
        Branch[] selection = (Branch[])this.getSelection().getAllElementsOfType(Branch.class);
        if (this.getIDComboBox().getSelectedItem() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You have to specify an ID.", "Error", 0);
            return false;
        }
        label.setID(CollidingIDsDialog.getInstance().checkConflicts(selection, this.getIDComboBox().getSelectedItem()));
        GraphicalLabelFormats f = label.getFormats();
        f.setLineColor(FormatUtils.getLineColor(this.getDocument()));
        this.getDocument().executeEdit(new InsertLabelsEdit(this.getDocument(), label, selection));
        return true;
    }

    protected JPanel getIDPanel() {
        if (this.idPanel == null) {
            this.idPanel = new JPanel();
            this.idPanel.setLayout(new GridBagLayout());
            this.idPanel.setBorder(BorderFactory.createTitledBorder(null, "Label ID", 0, 0, null, null));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            this.idPanel.add((Component)this.getIDComboBox(), gridBagConstraints);
        }
        return this.idPanel;
    }

    protected DataIDComboBox getIDComboBox() {
        if (this.idComboBox == null) {
            this.idComboBox = new DataIDComboBox(true);
        }
        return this.idComboBox;
    }

    protected JPanel getButtonsPanel() {
        this.getApplyButton().setVisible(false);
        return super.getButtonsPanel();
    }
}

