/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.editelement;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.TextElement;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.undo.edit.TextElementEdit;
import info.bioinfweb.treegraph.gui.dialogs.editelement.AbstractTextElementDialog;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class EditTextElementDialog
extends AbstractTextElementDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;

    public EditTextElementDialog(Frame owner) {
        super(owner);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    @Override
    protected boolean onExecute() {
        boolean result = this.getSelection().containsType(TextElement.class);
        if (result) {
            this.setTextElement(this.getSelection().getFirstElementOfType(TextElement.class));
        }
        return result;
    }

    protected boolean apply() {
        TextElementData data = new TextElementData();
        if (this.getDecimalCheckBox().isSelected()) {
            data.setDecimal(Math2.parseDouble(this.getValueTextField().getText()));
        } else {
            data.setText(this.getValueTextField().getText());
        }
        this.getDocument().executeEdit(new TextElementEdit(this.getDocument(), (TextElement[])this.getSelection().getAllElementsOfType(TextElement.class), data));
        return true;
    }

    private void initialize() {
        this.setHelpCode(5);
        this.setTitle("Edit text");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getValuesPanel(), null);
            this.jContentPane.add((Component)this.getPreviewPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }
}

