/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.editelement;

import info.bioinfweb.commons.swing.DecimalInput;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.undo.edit.BranchLengthEdit;
import info.bioinfweb.treegraph.gui.dialogs.EditDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class EditBranchLengthDialog
extends EditDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel inputPanel = null;
    private DecimalInput decimalInput = null;
    private JCheckBox hasLengthCheckBox = null;

    public EditBranchLengthDialog(Frame owner) {
        super(owner);
        this.setHelpCode(14);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    @Override
    protected boolean onExecute() {
        boolean result;
        Branch b = this.getSelection().getFirstElementOfType(Branch.class);
        boolean bl = result = b != null;
        if (result) {
            this.getHasLengthCheckBox().setSelected(b.hasLength());
            if (b.hasLength()) {
                this.getDecimalInput().setValue(b.getLength());
            } else {
                this.getDecimalInput().setValue(0);
            }
        }
        return result;
    }

    protected boolean apply() {
        double newValue = Double.NaN;
        if (this.getHasLengthCheckBox().isSelected()) {
            newValue = this.getDecimalInput().parseDouble();
        }
        this.getDocument().executeEdit(new BranchLengthEdit(this.getDocument(), this.getSelection().getFirstElementOfType(Branch.class), newValue));
        return true;
    }

    private void initialize() {
        this.setTitle("Edit branch length");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getInputPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getInputPanel() {
        if (this.inputPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridy = 0;
            this.inputPanel = new JPanel();
            this.inputPanel.setLayout(new GridBagLayout());
            this.inputPanel.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.inputPanel.add((Component)this.getHasLengthCheckBox(), gridBagConstraints);
            this.decimalInput = new DecimalInput("Branch length: ", this.inputPanel, 1, "#.##########");
        }
        return this.inputPanel;
    }

    public DecimalInput getDecimalInput() {
        this.getInputPanel();
        return this.decimalInput;
    }

    private JCheckBox getHasLengthCheckBox() {
        if (this.hasLengthCheckBox == null) {
            this.hasLengthCheckBox = new JCheckBox();
            this.hasLengthCheckBox.setText("Save branch length");
            this.hasLengthCheckBox.setSelected(true);
            this.hasLengthCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    EditBranchLengthDialog.this.getDecimalInput().setEnabled(EditBranchLengthDialog.this.getHasLengthCheckBox().isSelected());
                }
            });
        }
        return this.hasLengthCheckBox;
    }
}

