/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.editelement;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.TextElement;
import info.bioinfweb.treegraph.gui.dialogs.EditDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractTextElementDialog
extends EditDialog {
    private TextElement textElement = null;
    private JPanel valuesPanel = null;
    private JLabel textLabel = null;
    private JFormattedTextField valueTextField = null;
    private JFormattedTextField.AbstractFormatterFactory stringFormatterFactory = null;
    private JFormattedTextField.AbstractFormatterFactory decimalFormatterFactory = null;
    private JCheckBox decimalCheckBox = null;
    private JPanel previewPanel = null;
    private JLabel previewLabel = null;

    public AbstractTextElementDialog(Dialog owner) {
        super(owner);
    }

    public AbstractTextElementDialog(Frame owner) {
        super(owner);
    }

    public boolean execute() {
        this.getValueTextField().requestFocus();
        this.getValueTextField().selectAll();
        return super.execute();
    }

    protected TextElement getTextElement() {
        return this.textElement;
    }

    protected void setTextElement(TextElement textElement) {
        this.textElement = textElement;
        this.decimalFormatterFactory = new JFormattedTextField(textElement.getFormats().getDecimalFormat()).getFormatterFactory();
        this.setValue(textElement);
        this.setDecimalCheckBoxStatus();
        this.updatePreview();
    }

    protected JFormattedTextField.AbstractFormatterFactory getDecimalFormatterFactory() {
        return this.decimalFormatterFactory;
    }

    protected JFormattedTextField.AbstractFormatterFactory getStringFormatterFactory() {
        return this.stringFormatterFactory;
    }

    protected void updatePreview() {
        String text = this.getValueTextField().getText();
        if (this.getDecimalCheckBox().isSelected()) {
            try {
                text = this.textElement.getFormats().getDecimalFormat().format(Math2.parseDouble(this.getValueTextField().getText()));
            }
            catch (NumberFormatException e) {
                text = "ERROR: " + e.getMessage();
            }
        }
        if (text.equals("")) {
            text = " ";
        }
        this.getPreviewLabel().setText(text);
    }

    public void setValue(TextElement textElement) {
        if (textElement.getData().isDecimal()) {
            this.getValueTextField().setText("" + textElement.getData().getDecimal());
        } else {
            this.getValueTextField().setText(textElement.getData().getText());
        }
        this.getValueTextField().selectAll();
        this.getDecimalCheckBox().setSelected(textElement.getData().isDecimal());
    }

    private void setDecimalCheckBoxStatus() {
        boolean isDecimal = Math2.isDecimal(this.getValueTextField().getText());
        if (!isDecimal) {
            this.getDecimalCheckBox().setSelected(false);
        }
        this.getDecimalCheckBox().setEnabled(isDecimal);
    }

    protected JPanel getValuesPanel() {
        if (this.valuesPanel == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.gridwidth = 2;
            gridBagConstraints11.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 2.0;
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.textLabel = new JLabel();
            this.textLabel.setText("Text:  ");
            this.valuesPanel = new JPanel();
            this.valuesPanel.setLayout(new GridBagLayout());
            this.valuesPanel.setBorder(BorderFactory.createTitledBorder(null, "Value", 0, 0, null, null));
            this.valuesPanel.add((Component)this.textLabel, gridBagConstraints);
            this.valuesPanel.add((Component)this.getValueTextField(), gridBagConstraints1);
            this.valuesPanel.add((Component)this.getDecimalCheckBox(), gridBagConstraints11);
        }
        return this.valuesPanel;
    }

    protected JFormattedTextField getValueTextField() {
        if (this.valueTextField == null) {
            this.valueTextField = new JFormattedTextField();
            this.valueTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    AbstractTextElementDialog.this.setDecimalCheckBoxStatus();
                    AbstractTextElementDialog.this.updatePreview();
                }
            });
            this.stringFormatterFactory = this.valueTextField.getFormatterFactory();
        }
        return this.valueTextField;
    }

    protected JCheckBox getDecimalCheckBox() {
        if (this.decimalCheckBox == null) {
            this.decimalCheckBox = new JCheckBox();
            this.decimalCheckBox.setText("Save as decimal value");
            this.decimalCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String text = AbstractTextElementDialog.this.getValueTextField().getText();
                    if (AbstractTextElementDialog.this.getDecimalCheckBox().isSelected()) {
                        AbstractTextElementDialog.this.getValueTextField().setFormatterFactory(AbstractTextElementDialog.this.decimalFormatterFactory);
                    } else {
                        AbstractTextElementDialog.this.getValueTextField().setFormatterFactory(AbstractTextElementDialog.this.stringFormatterFactory);
                    }
                    AbstractTextElementDialog.this.getValueTextField().setText(text);
                    AbstractTextElementDialog.this.updatePreview();
                }
            });
        }
        return this.decimalCheckBox;
    }

    protected JPanel getPreviewPanel() {
        if (this.previewPanel == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            this.previewLabel = new JLabel();
            this.previewLabel.setText("Text");
            this.previewPanel = new JPanel();
            this.previewPanel.setLayout(new GridBagLayout());
            this.previewPanel.setBorder(BorderFactory.createTitledBorder(null, "Preview", 0, 0, null, null));
            this.previewPanel.add((Component)this.previewLabel, gridBagConstraints2);
        }
        return this.previewPanel;
    }

    private JLabel getPreviewLabel() {
        this.getPreviewPanel();
        return this.previewLabel;
    }
}

