/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeNameAdapter;
import info.bioinfweb.treegraph.document.undo.CompareTextElementDataParameters;
import info.bioinfweb.treegraph.document.undo.edit.SortLeavesEdit;
import info.bioinfweb.treegraph.gui.CurrentDirectoryModel;
import info.bioinfweb.treegraph.gui.dialogs.CompareTextElementDataParametersPanel;
import info.bioinfweb.treegraph.gui.dialogs.EditDialog;
import info.bioinfweb.treegraph.gui.dialogs.OpenedDocumentsComboBoxModel;
import info.bioinfweb.treegraph.gui.dialogs.io.TextFileFilter;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NodeDataComboBoxModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class SortLeavesDialog
extends EditDialog {
    private JPanel jContentPane = null;
    private JPanel leafAdapterPanel = null;
    private JPanel openedDocumentPanel;
    private JRadioButton openedDocumentRadioButton;
    private JRadioButton textFileRadioButton;
    private JTextField textFileField;
    private JComboBox<Document> openedDocumentComboBox;
    private JButton chooseTextFileButton;
    private final ButtonGroup orderSourceButtonGroup = new ButtonGroup();
    private CompareTextElementDataParametersPanel textElementDataParametersPanel;
    private JFileChooser fileChooser = null;
    private JComboBox<NodeBranchDataAdapter> sourceAdapterComboBox;
    private JComboBox<NodeBranchDataAdapter> targetAdapterComboBox;

    public SortLeavesDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void updateSourceAdapters() {
        if (this.getOpenedDocumentsComboBoxModel().getSelectedItem() != null) {
            this.getSourceAdapterModel().setAdapters(this.getOpenedDocumentsComboBoxModel().getSelectedItem().getTree(), true, true, true, false, false, "");
            this.getSourceAdapterModel().setSelectedAdapter(NodeNameAdapter.class);
        } else {
            this.getSourceAdapterModel().clear();
        }
    }

    @Override
    protected boolean onExecute() {
        boolean otherDocumentsOpen;
        this.setLocationRelativeTo(this.getOwner());
        this.getOpenedDocumentsComboBoxModel().refreshDocuments(false);
        this.getOpenedDocumentsComboBoxModel().removeElement(this.getDocument());
        boolean bl = otherDocumentsOpen = this.getOpenedDocumentsComboBoxModel().getSize() > 0;
        if (this.getOpenedDocumentRadioButton().isSelected() && !otherDocumentsOpen) {
            this.getTextFileRadioButton().setSelected(true);
        }
        this.getOpenedDocumentRadioButton().setEnabled(otherDocumentsOpen);
        this.getSourceAdapterComboBox().setEnabled(otherDocumentsOpen);
        this.getTargetAdapterModel().setAdapters(this.getDocument().getTree(), true, true, true, false, false, "");
        this.getTargetAdapterModel().setSelectedAdapter(this.getDocument().getDefaultLeafAdapter());
        this.updateSourceAdapters();
        return true;
    }

    protected boolean apply() {
        CompareTextElementDataParameters parameters = new CompareTextElementDataParameters();
        this.getTextElementDataParametersPanel().assignToParameters(parameters);
        List<TextElementData> newOrder = null;
        if (this.getTextFileRadioButton().isSelected()) {
            if (!"".equals(this.getTextFileField().getText())) {
                File file = new File(this.getTextFileField().getText());
                if (file.exists()) {
                    if (!file.isDirectory()) {
                        try {
                            newOrder = SortLeavesEdit.orderFromTextFile(file, parameters);
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog((Component)((Object)this), "The error \"" + e.toString() + "\" ocurred when trying to read the file \"" + file.getAbsolutePath() + "\".", "IO error", 0);
                        }
                    } else {
                        JOptionPane.showMessageDialog((Component)((Object)this), "The file \"" + file.getAbsolutePath() + "\" is a directory.", "Invalid file", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog((Component)((Object)this), "The file \"" + file.getAbsolutePath() + "\" could not be found.", "File not found", 0);
                }
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), "You have to specify a file.", "No file specified", 0);
            }
        } else {
            newOrder = SortLeavesEdit.orderFromDocument(this.getOpenedDocumentsComboBoxModel().getSelectedItem(), this.getSourceAdapterModel().getSelectedItem(), parameters);
        }
        if (newOrder != null) {
            SortLeavesEdit edit = new SortLeavesEdit(this.getDocument(), this.getSelection().getFirstNodeBranchOrRoot(), newOrder, this.getTargetAdapterModel().getSelectedItem(), parameters);
            this.getDocument().executeEdit(edit);
            if (edit.hasWarnings()) {
                JOptionPane.showMessageDialog((Component)((Object)this), edit.getWarningText(), "Warning", 2);
            }
            return true;
        }
        return false;
    }

    private void enableDisableOptionalElements() {
        boolean textFileOptionEnabled = this.getTextFileRadioButton().isSelected();
        this.getTextFileField().setEnabled(textFileOptionEnabled);
        this.getChooseTextFileButton().setEnabled(textFileOptionEnabled);
        this.getTextElementDataParametersPanel().getParseNumericValuesCheckBox().setEnabled(textFileOptionEnabled);
        this.getOpenedDocumentComboBox().setEnabled(!textFileOptionEnabled);
    }

    private void initialize() {
        this.setHelpCode(73);
        this.setMinimumSize(new Dimension(400, 150));
        this.setTitle("Sort terminal nodes");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add(this.getOpenedDocumentPanel());
            this.jContentPane.add(this.getLeafAdapterPanel());
            this.jContentPane.add(this.getTextElementDataParametersPanel());
            this.jContentPane.add(this.getButtonsPanel());
        }
        return this.jContentPane;
    }

    private JPanel getOpenedDocumentPanel() {
        if (this.openedDocumentPanel == null) {
            this.openedDocumentPanel = new JPanel();
            this.openedDocumentPanel.setBorder(new TitledBorder(null, "Source for new leaf order", 4, 2, null, null));
            GridBagLayout gbl_openedDocumentPanel = new GridBagLayout();
            gbl_openedDocumentPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            gbl_openedDocumentPanel.columnWidths = new int[3];
            gbl_openedDocumentPanel.columnWeights = new double[]{0.0, 1.0, 0.0};
            this.openedDocumentPanel.setLayout(gbl_openedDocumentPanel);
            GridBagConstraints gbc_textFileRadioButton = new GridBagConstraints();
            gbc_textFileRadioButton.anchor = 17;
            gbc_textFileRadioButton.insets = new Insets(0, 0, 5, 5);
            gbc_textFileRadioButton.gridx = 0;
            gbc_textFileRadioButton.gridy = 0;
            this.openedDocumentPanel.add((Component)this.getTextFileRadioButton(), gbc_textFileRadioButton);
            GridBagConstraints gbc_textFileField = new GridBagConstraints();
            gbc_textFileField.fill = 2;
            gbc_textFileField.insets = new Insets(0, 0, 5, 5);
            gbc_textFileField.gridx = 1;
            gbc_textFileField.gridy = 0;
            this.openedDocumentPanel.add((Component)this.getTextFileField(), gbc_textFileField);
            GridBagConstraints gbc_chooseTextFileButton = new GridBagConstraints();
            gbc_chooseTextFileButton.insets = new Insets(0, 0, 5, 0);
            gbc_chooseTextFileButton.gridx = 2;
            gbc_chooseTextFileButton.gridy = 0;
            this.openedDocumentPanel.add((Component)this.getChooseTextFileButton(), gbc_chooseTextFileButton);
            GridBagConstraints gbc_openedDocumentRadioButton = new GridBagConstraints();
            gbc_openedDocumentRadioButton.insets = new Insets(0, 0, 5, 5);
            gbc_openedDocumentRadioButton.anchor = 17;
            gbc_openedDocumentRadioButton.gridx = 0;
            gbc_openedDocumentRadioButton.gridy = 1;
            this.openedDocumentPanel.add((Component)this.getOpenedDocumentRadioButton(), gbc_openedDocumentRadioButton);
            GridBagConstraints gbc_openedDocumentComboBox = new GridBagConstraints();
            gbc_openedDocumentComboBox.gridwidth = 2;
            gbc_openedDocumentComboBox.weightx = 1.0;
            gbc_openedDocumentComboBox.insets = new Insets(0, 0, 5, 0);
            gbc_openedDocumentComboBox.fill = 2;
            gbc_openedDocumentComboBox.gridx = 1;
            gbc_openedDocumentComboBox.gridy = 1;
            this.openedDocumentPanel.add(this.getOpenedDocumentComboBox(), gbc_openedDocumentComboBox);
            GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
            gbc_lblNewLabel.gridwidth = 2;
            gbc_lblNewLabel.anchor = 17;
            gbc_lblNewLabel.insets = new Insets(0, 0, 5, 5);
            gbc_lblNewLabel.gridx = 1;
            gbc_lblNewLabel.gridy = 2;
            this.openedDocumentPanel.add((Component)new JLabel("Node/branch data column to load order values from: "), gbc_lblNewLabel);
            GridBagConstraints gbc_sourceAdapterComboBox = new GridBagConstraints();
            gbc_sourceAdapterComboBox.gridwidth = 2;
            gbc_sourceAdapterComboBox.insets = new Insets(0, 0, 5, 0);
            gbc_sourceAdapterComboBox.fill = 2;
            gbc_sourceAdapterComboBox.gridx = 1;
            gbc_sourceAdapterComboBox.gridy = 3;
            this.openedDocumentPanel.add(this.getSourceAdapterComboBox(), gbc_sourceAdapterComboBox);
        }
        return this.openedDocumentPanel;
    }

    private JPanel getLeafAdapterPanel() {
        if (this.leafAdapterPanel == null) {
            this.leafAdapterPanel = new JPanel();
            this.leafAdapterPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Node/branch data column used to identify leaf nodes to be sorted", 4, 2, null, new Color(0, 0, 0)));
            GridBagLayout gbl_leafAdapterPanel = new GridBagLayout();
            gbl_leafAdapterPanel.columnWeights = new double[]{1.0};
            this.leafAdapterPanel.setLayout(gbl_leafAdapterPanel);
            GridBagConstraints gbc_targetAdapterComboBox = new GridBagConstraints();
            gbc_targetAdapterComboBox.fill = 2;
            gbc_targetAdapterComboBox.gridx = 0;
            gbc_targetAdapterComboBox.gridy = 0;
            this.leafAdapterPanel.add(this.getTargetAdapterComboBox(), gbc_targetAdapterComboBox);
        }
        return this.leafAdapterPanel;
    }

    private JRadioButton getOpenedDocumentRadioButton() {
        if (this.openedDocumentRadioButton == null) {
            this.openedDocumentRadioButton = new JRadioButton("Opened document");
            this.orderSourceButtonGroup.add(this.openedDocumentRadioButton);
        }
        return this.openedDocumentRadioButton;
    }

    private JRadioButton getTextFileRadioButton() {
        if (this.textFileRadioButton == null) {
            this.textFileRadioButton = new JRadioButton("Text file");
            this.textFileRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SortLeavesDialog.this.enableDisableOptionalElements();
                }
            });
            this.orderSourceButtonGroup.add(this.textFileRadioButton);
            this.textFileRadioButton.setSelected(true);
        }
        return this.textFileRadioButton;
    }

    private JTextField getTextFileField() {
        if (this.textFileField == null) {
            this.textFileField = new JTextField();
            this.textFileField.setColumns(10);
        }
        return this.textFileField;
    }

    private JComboBox<Document> getOpenedDocumentComboBox() {
        if (this.openedDocumentComboBox == null) {
            this.openedDocumentComboBox = new JComboBox<Document>(new OpenedDocumentsComboBoxModel());
            this.openedDocumentComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        SortLeavesDialog.this.updateSourceAdapters();
                    }
                }
            });
        }
        return this.openedDocumentComboBox;
    }

    private OpenedDocumentsComboBoxModel getOpenedDocumentsComboBoxModel() {
        return (OpenedDocumentsComboBoxModel)this.getOpenedDocumentComboBox().getModel();
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setAcceptAllFileFilterUsed(true);
            TextFileFilter textFiler = new TextFileFilter();
            this.fileChooser.addChoosableFileFilter(textFiler);
            this.fileChooser.setFileFilter(textFiler);
            CurrentDirectoryModel.getInstance().addFileChooser(this.fileChooser);
        }
        return this.fileChooser;
    }

    private JButton getChooseTextFileButton() {
        if (this.chooseTextFileButton == null) {
            this.chooseTextFileButton = new JButton("...");
            this.chooseTextFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SortLeavesDialog.this.getFileChooser().showOpenDialog(SortLeavesDialog.this.chooseTextFileButton) == 0) {
                        SortLeavesDialog.this.getTextFileField().setText(SortLeavesDialog.this.getFileChooser().getSelectedFile().getAbsolutePath());
                    }
                }
            });
        }
        return this.chooseTextFileButton;
    }

    private CompareTextElementDataParametersPanel getTextElementDataParametersPanel() {
        if (this.textElementDataParametersPanel == null) {
            this.textElementDataParametersPanel = new CompareTextElementDataParametersPanel();
            this.textElementDataParametersPanel.setBorder(new TitledBorder(null, "Compare options", 4, 2, null, null));
        }
        return this.textElementDataParametersPanel;
    }

    private JComboBox<NodeBranchDataAdapter> getSourceAdapterComboBox() {
        if (this.sourceAdapterComboBox == null) {
            this.sourceAdapterComboBox = new JComboBox<NodeBranchDataAdapter>(new NodeDataComboBoxModel());
        }
        return this.sourceAdapterComboBox;
    }

    private NodeDataComboBoxModel getSourceAdapterModel() {
        return (NodeDataComboBoxModel)this.getSourceAdapterComboBox().getModel();
    }

    private JComboBox<NodeBranchDataAdapter> getTargetAdapterComboBox() {
        if (this.targetAdapterComboBox == null) {
            this.targetAdapterComboBox = new JComboBox<NodeBranchDataAdapter>(new NodeDataComboBoxModel());
        }
        return this.targetAdapterComboBox;
    }

    private NodeDataComboBoxModel getTargetAdapterModel() {
        return (NodeDataComboBoxModel)this.getTargetAdapterComboBox().getModel();
    }
}

