/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs;

import info.bioinfweb.treegraph.gui.dialogs.EditDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SearchTextDialog
extends EditDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel searchPanel = null;
    private JTextField searchTextField = null;
    private JCheckBox caseSensitiveCheckBox = null;
    private JCheckBox includeHiddenCheckBox = null;
    private JCheckBox wordsOnlyCheckBox = null;

    public SearchTextDialog(Frame owner) {
        super(owner);
        this.setHelpCode(13);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    @Override
    protected boolean onExecute() {
        this.getSearchTextField().requestFocus();
        this.getSearchTextField().selectAll();
        return true;
    }

    protected boolean apply() {
        return true;
    }

    public String getText() {
        return this.getSearchTextField().getText();
    }

    public boolean caseSensitive() {
        return this.getCaseSensitiveCheckBox().isSelected();
    }

    public boolean wordsOnly() {
        return this.getWordsOnlyCheckBox().isSelected();
    }

    public boolean includeInternalNodeNames() {
        return this.getIncludeHiddenCheckBox().isSelected();
    }

    private void initialize() {
        this.setTitle("Search text");
        this.setContentPane(this.getJContentPane());
        this.getApplyButton().setVisible(false);
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getSearchPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getSearchPanel() {
        if (this.searchPanel == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 3;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.searchPanel = new JPanel();
            this.searchPanel.setLayout(new GridBagLayout());
            this.searchPanel.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.searchPanel.add((Component)this.getSearchTextField(), gridBagConstraints);
            this.searchPanel.add((Component)this.getCaseSensitiveCheckBox(), gridBagConstraints1);
            this.searchPanel.add((Component)this.getIncludeHiddenCheckBox(), gridBagConstraints2);
            this.searchPanel.add((Component)this.getWordsOnlyCheckBox(), gridBagConstraints11);
        }
        return this.searchPanel;
    }

    private JTextField getSearchTextField() {
        if (this.searchTextField == null) {
            this.searchTextField = new JTextField();
        }
        return this.searchTextField;
    }

    private JCheckBox getCaseSensitiveCheckBox() {
        if (this.caseSensitiveCheckBox == null) {
            this.caseSensitiveCheckBox = new JCheckBox();
            this.caseSensitiveCheckBox.setText("Case sensitive");
        }
        return this.caseSensitiveCheckBox;
    }

    private JCheckBox getIncludeHiddenCheckBox() {
        if (this.includeHiddenCheckBox == null) {
            this.includeHiddenCheckBox = new JCheckBox();
            this.includeHiddenCheckBox.setText("Include internal node names");
        }
        return this.includeHiddenCheckBox;
    }

    private JCheckBox getWordsOnlyCheckBox() {
        if (this.wordsOnlyCheckBox == null) {
            this.wordsOnlyCheckBox = new JCheckBox();
            this.wordsOnlyCheckBox.setText("Words only");
        }
        return this.wordsOnlyCheckBox;
    }
}

