/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs;

import info.bioinfweb.treegraph.document.undo.format.ScaleBranchLengthsEdit;
import info.bioinfweb.treegraph.gui.dialogs.DistanceValueInput;
import info.bioinfweb.treegraph.gui.dialogs.EditDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ScaleBranchLengthsDialog
extends EditDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel lengthPanel = null;
    private DistanceValueInput lengthInput = null;

    public ScaleBranchLengthsDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setHelpCode(35);
        this.setMinimumSize(new Dimension(400, 150));
        this.setTitle("Scale branch lengths");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    @Override
    protected boolean onExecute() {
        boolean result = this.getDocument().getTree().hasAllBranchLengths();
        if (result) {
            this.getLengthInput().setValue(this.getDocument().getTree().longestPath() * (double)this.getDocument().getTree().getFormats().getBranchLengthScale().getInMillimeters());
        }
        return result;
    }

    protected boolean apply() {
        boolean result;
        boolean bl = result = this.getLengthInput().getValue().getInMillimeters() > 0.0f;
        if (result) {
            this.getDocument().executeEdit(new ScaleBranchLengthsEdit(this.getDocument(), this.getLengthInput().getValue().getInMillimeters()));
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "The lengths of the longest path must be greater than 0.", "Invalid length", 0);
        }
        return result;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getLengthPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getLengthPanel() {
        if (this.lengthPanel == null) {
            this.lengthPanel = new JPanel();
            this.lengthPanel.setLayout(new GridBagLayout());
            this.lengthPanel.setBorder(BorderFactory.createTitledBorder(null, "Length of the longest path", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.lengthInput = new DistanceValueInput("", this.lengthPanel, 0);
        }
        return this.lengthPanel;
    }

    private DistanceValueInput getLengthInput() {
        if (this.lengthInput == null) {
            this.getLengthPanel();
        }
        return this.lengthInput;
    }
}

