/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs;

import info.bioinfweb.treegraph.gui.dialogs.DecimalUnitInput;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class ResolutionInput
extends DecimalUnitInput {
    public static final String UNIT_PPI = "pixel per inch (ppi)";
    public static final String UNIT_PPMM = "pixel per mm";
    public static final float MM_PER_INCH = 25.4f;

    public ResolutionInput(String labelText, JPanel panel, int y) {
        super(labelText, panel, y);
    }

    public float getPixelsPerMillimeter() {
        float result = this.parseFloat();
        if (this.getComboBox().getSelectedItem().equals(UNIT_PPI)) {
            result = ResolutionInput.ppiToPPM(result);
        }
        return result;
    }

    public void setResolution(float value) {
        if (this.getComboBox().getSelectedItem().equals(UNIT_PPI)) {
            value = ResolutionInput.ppiToPPM(value);
        }
        this.setValue(value);
    }

    protected void customizeComboBox(JComboBox comboBox) {
        comboBox.addItem(UNIT_PPMM);
        comboBox.addItem(UNIT_PPI);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (((String)e.getItem()).equals(ResolutionInput.UNIT_PPMM)) {
                        ResolutionInput.this.setValue(ResolutionInput.ppiToPPM(ResolutionInput.this.parseFloat()));
                    } else {
                        ResolutionInput.this.setValue(ResolutionInput.ppmmToPPI(ResolutionInput.this.parseFloat()));
                    }
                }
            }
        });
    }

    public static float ppiToPPM(float ppi) {
        return ppi / 25.4f;
    }

    public static float ppmmToPPI(float ppmm) {
        return ppmm * 25.4f;
    }

    public float millimetersToPixels(float mm) {
        return mm * this.getPixelsPerMillimeter();
    }

    public float pixelsToMillimeters(float px) {
        return px / this.getPixelsPerMillimeter();
    }
}

