/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs;

import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.edit.ReplaceInNodeDataEdit;
import info.bioinfweb.treegraph.gui.dialogs.EditDialog;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NodeDataComboBoxModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class ReplaceInNodeDataDialog
extends EditDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel replacePanel = null;
    private JLabel nodeDataLabel = null;
    private JComboBox<NodeBranchDataAdapter> adapterComboBox = null;
    private JLabel replaceLabel = null;
    private JTextField replaceTextField = null;
    private JPanel positionPanel = null;
    private JRadioButton beginningRadioButton = null;
    private JRadioButton endRadioButton = null;
    private JRadioButton replaceRadioButton = null;
    private JLabel replaceTextLabel = null;
    private JTextField findTextField = null;
    private ButtonGroup insertGroup = new ButtonGroup();
    private JCheckBox caseSensitiveCheckBox = null;
    private JCheckBox wordsOnlyCheckBox = null;

    public ReplaceInNodeDataDialog(Frame owner) {
        super(owner);
        this.setHelpCode(6);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    public ReplaceInNodeDataDialog(Dialog owner) {
        super(owner);
        this.setHelpCode(6);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    @Override
    protected boolean onExecute() {
        ((NodeDataComboBoxModel)this.getAdapterComboBox().getModel()).setAdapters(this.getDocument().getTree());
        return true;
    }

    protected boolean apply() {
        if (this.getReplaceRadioButton().isSelected() && this.getFindTextField().getText().equals("")) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You have to specify a text to replace or choose to insert before or after the current text.", "Invalid input", 0);
            return false;
        }
        ReplaceInNodeDataEdit.InsertPosition pos = ReplaceInNodeDataEdit.InsertPosition.REPLACE;
        if (this.getBeginningRadioButton().isSelected()) {
            pos = ReplaceInNodeDataEdit.InsertPosition.BEFORE;
        } else if (this.getEndRadioButton().isSelected()) {
            pos = ReplaceInNodeDataEdit.InsertPosition.AFTER;
        }
        this.getDocument().executeEdit(new ReplaceInNodeDataEdit(this.getDocument(), (NodeBranchDataAdapter)this.getAdapterComboBox().getSelectedItem(), pos, this.getFindTextField().getText(), this.getReplaceTextField().getText(), this.getCaseSensitiveCheckBox().isSelected(), this.getWordsOnlyCheckBox().isSelected()));
        return true;
    }

    private void initialize() {
        this.setTitle("Add or replace text in node/branch data");
        this.setContentPane(this.getJContentPane());
        this.getApplyButton().setVisible(false);
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getReplacePanel(), null);
            this.jContentPane.add((Component)this.getPositionPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getReplacePanel() {
        if (this.replacePanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(5, 0, 5, 0);
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            this.nodeDataLabel = new JLabel();
            this.nodeDataLabel.setText("Node/branch data:");
            this.replacePanel = new JPanel();
            this.replacePanel.setLayout(new GridBagLayout());
            this.replacePanel.add((Component)this.nodeDataLabel, gridBagConstraints);
            this.replacePanel.add(this.getAdapterComboBox(), gridBagConstraints1);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridy = 1;
            this.replaceLabel = new JLabel();
            this.replaceLabel.setText("Text to insert: ");
            this.replacePanel.add((Component)this.replaceLabel, gridBagConstraints3);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.gridx = 1;
            this.replacePanel.add((Component)this.getReplaceTextField(), gridBagConstraints5);
        }
        return this.replacePanel;
    }

    private JComboBox<NodeBranchDataAdapter> getAdapterComboBox() {
        if (this.adapterComboBox == null) {
            this.adapterComboBox = new JComboBox<NodeBranchDataAdapter>(new NodeDataComboBoxModel());
        }
        return this.adapterComboBox;
    }

    private JTextField getReplaceTextField() {
        if (this.replaceTextField == null) {
            this.replaceTextField = new JTextField();
        }
        return this.replaceTextField;
    }

    private JPanel getPositionPanel() {
        if (this.positionPanel == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 4;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridwidth = 2;
            gridBagConstraints10.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints10.fill = 2;
            gridBagConstraints10.gridy = 3;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.gridx = 1;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.gridwidth = 2;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.gridy = 2;
            this.replaceTextLabel = new JLabel();
            this.replaceTextLabel.setText("Replace the following text");
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.gridy = 2;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridwidth = 3;
            gridBagConstraints7.gridy = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridwidth = 3;
            gridBagConstraints6.gridy = 0;
            this.positionPanel = new JPanel();
            this.positionPanel.setLayout(new GridBagLayout());
            this.positionPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Insert position/ replacement:", 1, 2, null, new Color(51, 51, 51)));
            this.positionPanel.add((Component)this.getBeginningRadioButton(), gridBagConstraints6);
            this.positionPanel.add((Component)this.getEndRadioButton(), gridBagConstraints7);
            this.positionPanel.add((Component)this.getReplaceRadioButton(), gridBagConstraints8);
            this.positionPanel.add((Component)this.replaceTextLabel, gridBagConstraints9);
            this.positionPanel.add((Component)this.getFindTextField(), gridBagConstraints10);
            this.positionPanel.add((Component)this.getCaseSensitiveCheckBox(), gridBagConstraints2);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints4.gridx = 2;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridy = 4;
            this.positionPanel.add((Component)this.getWordsOnlyCheckBox(), gridBagConstraints4);
        }
        return this.positionPanel;
    }

    private JRadioButton getBeginningRadioButton() {
        if (this.beginningRadioButton == null) {
            this.beginningRadioButton = new JRadioButton();
            this.beginningRadioButton.setText("Before the current text");
            this.insertGroup.add(this.beginningRadioButton);
        }
        return this.beginningRadioButton;
    }

    private JRadioButton getEndRadioButton() {
        if (this.endRadioButton == null) {
            this.endRadioButton = new JRadioButton();
            this.endRadioButton.setText("After the current text");
            this.insertGroup.add(this.endRadioButton);
        }
        return this.endRadioButton;
    }

    private JRadioButton getReplaceRadioButton() {
        if (this.replaceRadioButton == null) {
            this.replaceRadioButton = new JRadioButton();
            this.replaceRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean enabled = e.getItem().equals(ReplaceInNodeDataDialog.this.getReplaceRadioButton());
                    ReplaceInNodeDataDialog.this.getReplaceTextField().setEnabled(enabled);
                    ReplaceInNodeDataDialog.this.getCaseSensitiveCheckBox().setEnabled(enabled);
                    ReplaceInNodeDataDialog.this.getWordsOnlyCheckBox().setEnabled(enabled);
                }
            });
            this.insertGroup.add(this.replaceRadioButton);
            this.replaceRadioButton.setSelected(true);
        }
        return this.replaceRadioButton;
    }

    private JTextField getFindTextField() {
        if (this.findTextField == null) {
            this.findTextField = new JTextField();
        }
        return this.findTextField;
    }

    private JCheckBox getCaseSensitiveCheckBox() {
        if (this.caseSensitiveCheckBox == null) {
            this.caseSensitiveCheckBox = new JCheckBox();
            this.caseSensitiveCheckBox.setText("Case sensitive");
        }
        return this.caseSensitiveCheckBox;
    }

    private JCheckBox getWordsOnlyCheckBox() {
        if (this.wordsOnlyCheckBox == null) {
            this.wordsOnlyCheckBox = new JCheckBox();
            this.wordsOnlyCheckBox.setText("Words only");
        }
        return this.wordsOnlyCheckBox;
    }
}

