/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs;

import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.PreferencesConstants;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.wikihelp.client.OkCancelApplyWikiHelpDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class PreferencesDialog
extends OkCancelApplyWikiHelpDialog
implements PreferencesConstants {
    private JPanel preferencesPanel;
    private JCheckBox checkForUpdatesCB;

    public PreferencesDialog() {
        super((Frame)MainFrame.getInstance(), true, Main.getInstance().getWikiHelp());
        this.setTitle("TreeGraph 2 Preferences");
        this.setHelpCode(97);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.getPreferencesPanel());
        this.getContentPane().add(this.getButtonsPanel());
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    protected void addMoreButtons(JPanel buttonPanel) {
        JButton restoreDefaultsButton = new JButton("Restore defaults");
        restoreDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.getCheckForUpdatesCB().setSelected(true);
            }
        });
        buttonPanel.add(restoreDefaultsButton);
    }

    private JPanel getPreferencesPanel() {
        if (this.preferencesPanel == null) {
            this.preferencesPanel = new JPanel();
            GridBagLayout layout = new GridBagLayout();
            layout.columnWidths = new int[2];
            layout.rowHeights = new int[3];
            layout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            layout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.preferencesPanel.setLayout(layout);
            this.preferencesPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            GridBagConstraints checkForUpdatesGBC = new GridBagConstraints();
            checkForUpdatesGBC.insets = new Insets(0, 0, 5, 0);
            checkForUpdatesGBC.gridx = 0;
            checkForUpdatesGBC.gridy = 0;
            this.preferencesPanel.add((Component)this.getCheckForUpdatesCB(), checkForUpdatesGBC);
        }
        return this.preferencesPanel;
    }

    private JCheckBox getCheckForUpdatesCB() {
        if (this.checkForUpdatesCB == null) {
            this.checkForUpdatesCB = new JCheckBox("Check for updates on start");
        }
        return this.checkForUpdatesCB;
    }

    public boolean execute() {
        Preferences preferences = Main.getInstance().getPreferences();
        this.getCheckForUpdatesCB().setSelected(preferences.getBoolean("doVersionCheck", true));
        return super.execute();
    }

    protected boolean apply() {
        Preferences preferences = Main.getInstance().getPreferences();
        preferences.putBoolean("doVersionCheck", this.getCheckForUpdatesCB().isSelected());
        return true;
    }
}

