/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs;

import info.bioinfweb.treegraph.document.format.Margin;
import info.bioinfweb.treegraph.gui.dialogs.DistanceValueInput;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MarginInput {
    private JLabel titleLabel = null;
    private DistanceValueInput left = null;
    private DistanceValueInput right = null;
    private DistanceValueInput top = null;
    private DistanceValueInput bottom = null;

    private void initLabel(String title, JPanel panel, int y) {
        this.titleLabel = new JLabel(String.valueOf(title) + " margin: ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.ipadx = 3;
        gbc.anchor = 17;
        panel.add((Component)this.titleLabel, gbc);
    }

    public MarginInput(String title, JPanel panel, int y0) {
        if (title != null && !"".equals(title)) {
            this.initLabel(title, panel, y0);
            ++y0;
        }
        this.left = new DistanceValueInput("Left: ", panel, y0);
        this.right = new DistanceValueInput("Right: ", panel, y0 + 2);
        this.top = new DistanceValueInput("Top: ", panel, y0 + 4);
        this.bottom = new DistanceValueInput("Bottom: ", panel, y0 + 6);
    }

    public DistanceValueInput getBottom() {
        return this.bottom;
    }

    public DistanceValueInput getLeft() {
        return this.left;
    }

    public DistanceValueInput getRight() {
        return this.right;
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    public DistanceValueInput getTop() {
        return this.top;
    }

    public void setValue(Margin m) {
        this.getLeft().setValue(m.getLeft());
        this.getRight().setValue(m.getRight());
        this.getTop().setValue(m.getTop());
        this.getBottom().setValue(m.getBottom());
    }

    public void assignValueTo(Margin m) {
        this.getLeft().assignValueTo(m.getLeft());
        this.getRight().assignValueTo(m.getRight());
        this.getTop().assignValueTo(m.getTop());
        this.getBottom().assignValueTo(m.getBottom());
    }

    public void resetChangeMonitors() {
        this.getLeft().getChangeMonitor().reset();
        this.getTop().getChangeMonitor().reset();
        this.getRight().getChangeMonitor().reset();
        this.getBottom().getChangeMonitor().reset();
    }
}

