/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs;

import info.bioinfweb.treegraph.document.format.GlobalFormats;
import info.bioinfweb.treegraph.document.undo.format.GlobalFormatsEdit;
import info.bioinfweb.treegraph.gui.dialogs.DistanceValueInput;
import info.bioinfweb.treegraph.gui.dialogs.EditDialog;
import info.bioinfweb.treegraph.gui.dialogs.MarginInput;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GlobalFormatsDialog
extends EditDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JTabbedPane formatsTabbedPane = null;
    private JPanel documentPanel = null;
    private MarginInput documentMarginInput = null;
    private DistanceValueInput branchLengthScaleInput = null;
    private JColorChooser colorChooser = null;
    private JCheckBox showRootedCheckBox = null;
    private JCheckBox showScaleBarCheckBox = null;
    private JCheckBox alignToSubtreeCheckBox = null;
    private JCheckBox labelsToLeftCheckBox = null;

    public GlobalFormatsDialog(Frame owner) {
        super(owner);
        this.setHelpCode(48);
        this.initialize();
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    @Override
    protected boolean onExecute() {
        this.setValues(this.getDocument().getTree().getFormats());
        return true;
    }

    protected boolean apply() {
        this.getDocument().executeEdit(new GlobalFormatsEdit(this.getDocument(), this.getValues()));
        return true;
    }

    private void setValues(GlobalFormats f) {
        this.documentMarginInput.setValue(f.getDocumentMargin());
        this.branchLengthScaleInput.setValue(f.getBranchLengthScale());
        this.getShowScaleBarCheckBox().setSelected(f.getShowScaleBar());
        this.getShowRootedCheckBox().setSelected(f.getShowRooted());
        this.getAlignToSubtreeCheckBox().setSelected(f.getAlignLegendsToSubtree());
        this.getLabelsToLeftCheckBox().setSelected(f.getPositionLabelsToLeft());
        this.colorChooser.setColor(f.getBackgroundColor());
    }

    private GlobalFormats getValues() {
        GlobalFormats result = new GlobalFormats();
        this.documentMarginInput.assignValueTo(result.getDocumentMargin());
        this.branchLengthScaleInput.assignValueTo(result.getBranchLengthScale());
        result.setShowScaleBar(this.getShowScaleBarCheckBox().isSelected());
        result.setShowRooted(this.getShowRootedCheckBox().isSelected());
        result.setAlignLegendsToSubtree(this.getAlignToSubtreeCheckBox().isSelected());
        result.setPositionLabelsToLeft(this.getLabelsToLeftCheckBox().isSelected());
        result.setBackgroundColor(this.colorChooser.getColor());
        return result;
    }

    private void addSpacer(JPanel panel, int y) {
        JLabel spacer = new JLabel(" ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.ipadx = 3;
        gbc.anchor = 17;
        panel.add((Component)spacer, gbc);
    }

    private void initialize() {
        this.setTitle("Global document formats");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getFormatsTabbedPane(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getDocumentPanel() {
        if (this.documentPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridy = 1;
            GridBagConstraints alignTosubtreeGBC = new GridBagConstraints();
            alignTosubtreeGBC.anchor = 17;
            alignTosubtreeGBC.gridx = 0;
            alignTosubtreeGBC.gridy = 2;
            alignTosubtreeGBC.gridwidth = 3;
            GridBagConstraints showScaleBarGBC = new GridBagConstraints();
            showScaleBarGBC.anchor = 17;
            showScaleBarGBC.gridx = 1;
            showScaleBarGBC.gridy = 0;
            showScaleBarGBC.gridwidth = 2;
            GridBagConstraints showRootedGBC = new GridBagConstraints();
            showRootedGBC.anchor = 17;
            showRootedGBC.gridx = 0;
            showRootedGBC.gridy = 0;
            showRootedGBC.gridwidth = 1;
            this.documentPanel = new JPanel();
            this.documentPanel.setLayout(new GridBagLayout());
            this.documentPanel.add((Component)this.getShowRootedCheckBox(), showRootedGBC);
            this.documentPanel.add((Component)this.getShowScaleBarCheckBox(), showScaleBarGBC);
            this.documentPanel.add((Component)this.getAlignToSubtreeCheckBox(), alignTosubtreeGBC);
            this.documentPanel.add((Component)this.getLabelsToLeftCheckBox(), gridBagConstraints);
            this.addSpacer(this.documentPanel, 3);
            this.branchLengthScaleInput = new DistanceValueInput("Distance per branch length unit: ", this.documentPanel, 4);
            this.addSpacer(this.documentPanel, 6);
            this.documentMarginInput = new MarginInput("Document", this.documentPanel, 7);
        }
        return this.documentPanel;
    }

    private JColorChooser getColorChooser() {
        if (this.colorChooser == null) {
            this.colorChooser = new JColorChooser(Color.BLACK);
        }
        return this.colorChooser;
    }

    private JTabbedPane getFormatsTabbedPane() {
        if (this.formatsTabbedPane == null) {
            this.formatsTabbedPane = new JTabbedPane();
            this.formatsTabbedPane.addTab("Document", this.getDocumentPanel());
            this.formatsTabbedPane.addTab("Background color", this.getColorChooser());
        }
        return this.formatsTabbedPane;
    }

    private JCheckBox getShowRootedCheckBox() {
        if (this.showRootedCheckBox == null) {
            this.showRootedCheckBox = new JCheckBox();
            this.showRootedCheckBox.setText("Show rooted tree");
        }
        return this.showRootedCheckBox;
    }

    private JCheckBox getShowScaleBarCheckBox() {
        if (this.showScaleBarCheckBox == null) {
            this.showScaleBarCheckBox = new JCheckBox();
            this.showScaleBarCheckBox.setText("Show scale bar");
        }
        return this.showScaleBarCheckBox;
    }

    private JCheckBox getAlignToSubtreeCheckBox() {
        if (this.alignToSubtreeCheckBox == null) {
            this.alignToSubtreeCheckBox = new JCheckBox();
            this.alignToSubtreeCheckBox.setText("Horizontal alignment of legends to subtree (Uncheck to align to the whole tree.)");
        }
        return this.alignToSubtreeCheckBox;
    }

    private JCheckBox getLabelsToLeftCheckBox() {
        if (this.labelsToLeftCheckBox == null) {
            this.labelsToLeftCheckBox = new JCheckBox();
            this.labelsToLeftCheckBox.setText("Label block overhang only on left side (only relevant in the phylogram/chronogram view)");
        }
        return this.labelsToLeftCheckBox;
    }
}

