/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs;

import info.bioinfweb.treegraph.document.format.DistanceValue;
import info.bioinfweb.treegraph.gui.dialogs.DecimalUnitInput;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class DistanceValueInput
extends DecimalUnitInput {
    public static final String UNIT_MILLIMETERS = "mm";
    public static final String UNIT_POINTS = "pt";

    public DistanceValueInput(String labelText, JPanel panel, int y) {
        this(labelText, panel, 0, y);
    }

    public DistanceValueInput(String labelText, JPanel panel, int x, int y) {
        super(labelText, panel, x, y);
    }

    @Override
    protected void customizeComboBox(JComboBox<String> comboBox) {
        comboBox.addItem(UNIT_MILLIMETERS);
        comboBox.addItem(UNIT_POINTS);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (((String)e.getItem()).equals(DistanceValueInput.UNIT_MILLIMETERS)) {
                        DistanceValueInput.this.setValue(DistanceValue.pointsToMillimeters(DistanceValueInput.this.parseFloat()));
                    } else {
                        DistanceValueInput.this.setValue(DistanceValue.millimetersToPoints(DistanceValueInput.this.parseFloat()));
                    }
                }
            }
        });
    }

    public void setValue(DistanceValue distanceValue) {
        if (((String)this.getComboBox().getSelectedItem()).equals(UNIT_MILLIMETERS)) {
            this.setValue(distanceValue.getInMillimeters());
        } else {
            this.setValue(distanceValue.getInPoints());
        }
    }

    public void assignValueTo(DistanceValue distanceValue) {
        float value = this.parseFloat();
        if (((String)this.getComboBox().getSelectedItem()).equals(UNIT_MILLIMETERS)) {
            distanceValue.setInMillimeters(value);
        } else {
            distanceValue.setInPoints(value);
        }
    }

    public DistanceValue getValue() {
        DistanceValue result = new DistanceValue();
        this.assignValueTo(result);
        return result;
    }
}

