/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs;

import info.bioinfweb.treegraph.document.undo.CompareTextElementDataParameters;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class CompareTextElementDataParametersPanel
extends JPanel {
    private JCheckBox ignoreWhitespaceCheckBox;
    private JCheckBox caseCheckBox;
    private JCheckBox distinguishSpaceUnderscoreCheckBox;
    private JCheckBox parseNumericValuesCheckBox;

    public CompareTextElementDataParametersPanel() {
        this.initialize();
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.getIgnoreWhitespaceCheckBox().setEnabled(flag);
        this.getCaseCheckBox().setEnabled(flag);
        this.getDistinguishSpaceUnderscoreCheckBox().setEnabled(flag);
        this.getParseNumericValuesCheckBox().setEnabled(flag);
    }

    public void assignToParameters(CompareTextElementDataParameters parameters) {
        parameters.setIgnoreWhitespace(this.getIgnoreWhitespaceCheckBox().isSelected());
        parameters.setDistinguishSpaceUnderscore(this.getDistinguishSpaceUnderscoreCheckBox().isSelected());
        parameters.setCaseSensitive(this.getCaseCheckBox().isSelected());
        parameters.setParseNumericValues(this.getParseNumericValuesCheckBox().isSelected());
    }

    public void assignFromParameters(CompareTextElementDataParameters parameters) {
        this.getIgnoreWhitespaceCheckBox().setSelected(parameters.isIgnoreWhitespace());
        this.getCaseCheckBox().setSelected(parameters.isCaseSensitive());
        this.getDistinguishSpaceUnderscoreCheckBox().setSelected(parameters.isDistinguishSpaceUnderscore());
        this.getParseNumericValuesCheckBox().setSelected(parameters.isParseNumericValues());
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[3];
        gridBagLayout.rowHeights = new int[3];
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        GridBagConstraints gbc_chckbxNewCheckBox = new GridBagConstraints();
        gbc_chckbxNewCheckBox.anchor = 17;
        gbc_chckbxNewCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxNewCheckBox.gridx = 0;
        gbc_chckbxNewCheckBox.gridy = 0;
        this.add((Component)this.getIgnoreWhitespaceCheckBox(), gbc_chckbxNewCheckBox);
        GridBagConstraints gbc_chckbxNewCheckBox_1 = new GridBagConstraints();
        gbc_chckbxNewCheckBox_1.anchor = 17;
        gbc_chckbxNewCheckBox_1.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxNewCheckBox_1.gridx = 1;
        gbc_chckbxNewCheckBox_1.gridy = 0;
        this.add((Component)this.getDistinguishSpaceUnderscoreCheckBox(), gbc_chckbxNewCheckBox_1);
        GridBagConstraints gbc_checkBox = new GridBagConstraints();
        gbc_checkBox.anchor = 17;
        gbc_checkBox.insets = new Insets(0, 0, 0, 5);
        gbc_checkBox.gridx = 0;
        gbc_checkBox.gridy = 1;
        this.add((Component)this.getCaseCheckBox(), gbc_checkBox);
        GridBagConstraints gbc_chckbxNewCheckBox_2 = new GridBagConstraints();
        gbc_chckbxNewCheckBox_2.anchor = 17;
        gbc_chckbxNewCheckBox_2.gridx = 1;
        gbc_chckbxNewCheckBox_2.gridy = 1;
        this.add((Component)this.getParseNumericValuesCheckBox(), gbc_chckbxNewCheckBox_2);
    }

    public JCheckBox getIgnoreWhitespaceCheckBox() {
        if (this.ignoreWhitespaceCheckBox == null) {
            this.ignoreWhitespaceCheckBox = new JCheckBox("Ignore leading and trailing white space");
            this.ignoreWhitespaceCheckBox.setSelected(false);
        }
        return this.ignoreWhitespaceCheckBox;
    }

    public JCheckBox getCaseCheckBox() {
        if (this.caseCheckBox == null) {
            this.caseCheckBox = new JCheckBox("Case sensitive");
        }
        return this.caseCheckBox;
    }

    public JCheckBox getDistinguishSpaceUnderscoreCheckBox() {
        if (this.distinguishSpaceUnderscoreCheckBox == null) {
            this.distinguishSpaceUnderscoreCheckBox = new JCheckBox("Distinguish between space (\" \") and underscore (\"_\")");
        }
        return this.distinguishSpaceUnderscoreCheckBox;
    }

    public JCheckBox getParseNumericValuesCheckBox() {
        if (this.parseNumericValuesCheckBox == null) {
            this.parseNumericValuesCheckBox = new JCheckBox("Parse numeric values if possible");
            this.parseNumericValuesCheckBox.setSelected(true);
        }
        return this.parseNumericValuesCheckBox;
    }
}

