/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs;

import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.tools.IDManager;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.wikihelp.client.OkCancelApplyWikiHelpDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CollidingIDsDialog
extends OkCancelApplyWikiHelpDialog {
    private static final long serialVersionUID = 1L;
    private static CollidingIDsDialog firstInstance = null;
    private String initialNewID = null;
    private Branch[] selection = null;
    private List<String> additionalReservedIDs = null;
    private JPanel jContentPane = null;
    private JPanel inputPanel = null;
    private JLabel messageLabel = null;
    private JLabel changeID2Label = null;
    private JLabel changeID1Label = null;
    private JTextField newIDTextField = null;
    private JTextField presentIDTextField = null;
    private JRadioButton overwriteRadioButton = null;
    private JRadioButton changeIDRadioButton = null;
    private JLabel overwriteLabel = null;
    private JLabel changeIDLabel = null;
    private ButtonGroup radioGroup = null;

    private CollidingIDsDialog(Frame owner) {
        super(owner, true, Main.getInstance().getWikiHelp());
        this.initialize();
        this.setHelpCode(58);
    }

    public static CollidingIDsDialog getInstance() {
        if (firstInstance == null) {
            firstInstance = new CollidingIDsDialog(MainFrame.getInstance());
        }
        return firstInstance;
    }

    private void initialize() {
        this.setTitle("Conflicting IDs");
        this.setContentPane(this.getJContentPane());
        this.setSize(450, 280);
        this.getRadioGroup();
        this.getCancelButton().setVisible(false);
        this.getApplyButton().setVisible(false);
        this.setDefaultCloseOperation(0);
    }

    protected boolean apply() {
        boolean result = this.idsEqual();
        if (this.getOverwriteRadioButton().isSelected()) {
            return true;
        }
        if (result) {
            JOptionPane.showMessageDialog((Component)((Object)this), "The IDs are still equal. Please type in two different IDs.", "Error", 0);
            return false;
        }
        String idText = "";
        if ((IDManager.idConflict(this.getPresentLabelID(), this.selection) || this.additionalReservedIDs.contains(this.getPresentLabelID())) && !this.getPresentLabelID().equals(this.initialNewID)) {
            idText = "\"" + this.getPresentLabelID() + "\"";
        }
        if ((IDManager.idConflict(this.getNewLabelID(), this.selection) || this.additionalReservedIDs.contains(this.getNewLabelID())) && (!this.getNewLabelID().equals(this.initialNewID) || this.getPresentLabelID().equals(this.initialNewID))) {
            idText = idText.equals("") ? "\"" + this.getNewLabelID() + "\"" : String.valueOf(idText) + " and \"" + this.getNewLabelID() + "\"";
        }
        if (!idText.equals("")) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Elements with the ID(s) " + idText + " are already present on the selected branch(es). Please specify " + "a different name.", "Error", 0);
        }
        return idText.equals("");
    }

    public String checkConflicts(Branch[] selection, String id) {
        return this.checkConflicts(selection, id, Collections.emptyList());
    }

    public String checkConflicts(Branch[] selection, String id, List<String> additionalReservedIDs) {
        CollidingIDsDialog dialog;
        if (IDManager.idConflict(id, selection) && !(dialog = CollidingIDsDialog.getInstance()).promt(id, selection, additionalReservedIDs)) {
            int i = 0;
            while (i < selection.length) {
                if (IDManager.idExistsOnNode(selection[i].getTargetNode(), id)) {
                    IDManager.renameID(id, dialog.getPresentLabelID(), selection[i].getTargetNode());
                }
                ++i;
            }
            id = dialog.getNewLabelID();
        }
        return id;
    }

    public boolean promt(String id, Branch[] selection) {
        return this.promt(id, selection, Collections.emptyList());
    }

    public boolean promt(String id, Branch[] selection, List<String> additionalReservedIDs) {
        this.selection = selection;
        this.additionalReservedIDs = additionalReservedIDs;
        this.initialNewID = id;
        this.getNewIDTextField().setText(id);
        this.getPresentIDTextField().setText(id);
        this.setLocationRelativeTo(this.getOwner());
        this.execute();
        return this.overwriteRadioButton.isSelected();
    }

    public String getPresentLabelID() {
        return this.getPresentIDTextField().getText();
    }

    public String getNewLabelID() {
        return this.getNewIDTextField().getText();
    }

    private boolean idsEqual() {
        return this.getPresentLabelID().equals(this.getNewLabelID());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getInputPanel(), null);
            this.jContentPane.add(this.getButtonsPanel());
        }
        return this.jContentPane;
    }

    private JPanel getInputPanel() {
        if (this.inputPanel == null) {
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 1;
            gridBagConstraints18.fill = 2;
            gridBagConstraints18.gridwidth = 2;
            gridBagConstraints18.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints18.gridy = 2;
            this.changeIDLabel = new JLabel();
            this.changeIDLabel.setText("<html><body>Change IDs.</body></html>");
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 1;
            gridBagConstraints17.fill = 2;
            gridBagConstraints17.gridwidth = 2;
            gridBagConstraints17.insets = new Insets(0, 0, 6, 0);
            gridBagConstraints17.gridy = 1;
            this.overwriteLabel = new JLabel();
            this.overwriteLabel.setText("<html><body>Overwrite</html></body>");
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.insets = new Insets(0, 3, 0, 0);
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.gridy = 2;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.insets = new Insets(0, 3, 6, 0);
            gridBagConstraints14.gridy = 1;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.insets = new Insets(0, 0, 0, 3);
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.gridy = 4;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.gridx = 2;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.insets = new Insets(0, 0, 0, 3);
            gridBagConstraints9.fill = 1;
            gridBagConstraints9.gridy = 3;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.gridx = 2;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.gridy = 3;
            this.changeID1Label = new JLabel();
            this.changeID1Label.setText("New ID for new Label: ");
            this.changeID1Label.setEnabled(true);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 4;
            this.changeID2Label = new JLabel();
            this.changeID2Label.setText("New ID for old Label: ");
            this.changeID2Label.setEnabled(true);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 11;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(3, 3, 16, 3);
            gridBagConstraints.gridy = 0;
            this.messageLabel = new JLabel();
            this.messageLabel.setText("<html><body>An element (label, hidden node/branch data) with the IDs you selected already exists on this branch. Select \"Overwrite\" if you want to delete the element currently present or select \"Change IDs\" to rename one or both of the conflicting IDs.</body></html>");
            this.messageLabel.setEnabled(true);
            this.inputPanel = new JPanel();
            this.inputPanel.setLayout(new GridBagLayout());
            this.inputPanel.add((Component)this.messageLabel, gridBagConstraints);
            this.inputPanel.add((Component)this.changeID2Label, gridBagConstraints6);
            this.inputPanel.add((Component)this.changeID1Label, gridBagConstraints8);
            this.inputPanel.add((Component)this.getNewIDTextField(), gridBagConstraints9);
            this.inputPanel.add((Component)this.getPresentIDTextField(), gridBagConstraints13);
            this.inputPanel.add((Component)this.getOverwriteRadioButton(), gridBagConstraints14);
            this.inputPanel.add((Component)this.getChangeIDRadioButton(), gridBagConstraints15);
            this.inputPanel.add((Component)this.overwriteLabel, gridBagConstraints17);
            this.inputPanel.add((Component)this.changeIDLabel, gridBagConstraints18);
        }
        return this.inputPanel;
    }

    private JTextField getNewIDTextField() {
        if (this.newIDTextField == null) {
            this.newIDTextField = new JTextField();
            this.newIDTextField.setEnabled(true);
        }
        return this.newIDTextField;
    }

    private JTextField getPresentIDTextField() {
        if (this.presentIDTextField == null) {
            this.presentIDTextField = new JTextField();
            this.presentIDTextField.setEnabled(true);
        }
        return this.presentIDTextField;
    }

    private ButtonGroup getRadioGroup() {
        if (this.radioGroup == null) {
            this.radioGroup = new ButtonGroup();
            this.radioGroup.add(this.getChangeIDRadioButton());
            this.radioGroup.add(this.getOverwriteRadioButton());
        }
        return this.radioGroup;
    }

    private JRadioButton getOverwriteRadioButton() {
        if (this.overwriteRadioButton == null) {
            this.overwriteRadioButton = new JRadioButton();
        }
        return this.overwriteRadioButton;
    }

    private JRadioButton getChangeIDRadioButton() {
        if (this.changeIDRadioButton == null) {
            this.changeIDRadioButton = new JRadioButton();
            this.changeIDRadioButton.setSelected(true);
            this.changeIDRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CollidingIDsDialog.this.getNewIDTextField().setEnabled(CollidingIDsDialog.this.getChangeIDRadioButton().isSelected());
                    CollidingIDsDialog.this.getPresentIDTextField().setEnabled(CollidingIDsDialog.this.getChangeIDRadioButton().isSelected());
                    CollidingIDsDialog.this.changeID1Label.setEnabled(CollidingIDsDialog.this.getChangeIDRadioButton().isSelected());
                    CollidingIDsDialog.this.changeID2Label.setEnabled(CollidingIDsDialog.this.getChangeIDRadioButton().isSelected());
                }
            });
        }
        return this.changeIDRadioButton;
    }
}

