/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.commons.text.StringUtils;
import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.nodebranchdata.HiddenDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.TextLabelAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.VoidNodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.edit.CollapseNodesBySupportEdit;
import info.bioinfweb.treegraph.gui.dialogs.EditDialog;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput.NodeBranchDataInput;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.wikihelp.client.WikiHelp;
import info.bioinfweb.wikihelp.client.WikiHelpOptionPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CollapseNodesBySupportDialog
extends EditDialog {
    private JPanel jContentPane = null;
    private JPanel collapseNodesPanel = null;
    private NodeBranchDataInput adapterInput = null;
    private JFormattedTextField thresholdTextField;

    public CollapseNodesBySupportDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setHelpCode(71);
        this.setMinimumSize(new Dimension(400, 150));
        this.setTitle("Collapse nodes by support value");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add(this.getCollapseNodesPanel());
            this.jContentPane.add(this.getButtonsPanel());
        }
        return this.jContentPane;
    }

    private JPanel getCollapseNodesPanel() {
        if (this.collapseNodesPanel == null) {
            this.collapseNodesPanel = new JPanel();
            GridBagLayout gbl_collapseNodesPanel = new GridBagLayout();
            gbl_collapseNodesPanel.columnWidths = new int[3];
            gbl_collapseNodesPanel.rowHeights = new int[3];
            gbl_collapseNodesPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
            gbl_collapseNodesPanel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.collapseNodesPanel.setLayout(gbl_collapseNodesPanel);
            JLabel thresholdLabel = new JLabel("Threshold:");
            GridBagConstraints gbc_thresholdLabel = new GridBagConstraints();
            gbc_thresholdLabel.insets = new Insets(3, 3, 5, 5);
            gbc_thresholdLabel.anchor = 17;
            gbc_thresholdLabel.gridx = 0;
            gbc_thresholdLabel.gridy = 0;
            this.collapseNodesPanel.add((Component)thresholdLabel, gbc_thresholdLabel);
            JLabel supportValuesLabel = new JLabel("Support values column:");
            GridBagConstraints gbc_lblSupportValuesColumn = new GridBagConstraints();
            gbc_lblSupportValuesColumn.anchor = 17;
            gbc_lblSupportValuesColumn.insets = new Insets(3, 3, 0, 5);
            gbc_lblSupportValuesColumn.gridx = 0;
            gbc_lblSupportValuesColumn.gridy = 1;
            this.collapseNodesPanel.add((Component)supportValuesLabel, gbc_lblSupportValuesColumn);
            this.thresholdTextField = new JFormattedTextField(StringUtils.DOUBLE_FORMAT);
            GridBagConstraints gbc_thresholdTextField = new GridBagConstraints();
            gbc_thresholdTextField.insets = new Insets(2, 0, 2, 0);
            gbc_thresholdTextField.fill = 2;
            gbc_thresholdTextField.gridx = 1;
            gbc_thresholdTextField.gridy = 0;
            this.collapseNodesPanel.add((Component)this.thresholdTextField, gbc_thresholdTextField);
            this.adapterInput = new NodeBranchDataInput(this.collapseNodesPanel, 1, 1);
        }
        return this.collapseNodesPanel;
    }

    private JFormattedTextField getThresholdTextField() {
        this.getCollapseNodesPanel();
        return this.thresholdTextField;
    }

    private double getThreshold() {
        double result;
        try {
            result = Math2.parseDouble(this.getThresholdTextField().getText());
        }
        catch (NumberFormatException e) {
            result = Double.NaN;
        }
        return result;
    }

    @Override
    protected boolean onExecute() {
        this.adapterInput.setAdapters(this.getDocument().getTree(), false, true, true, true, false, "");
        if (this.adapterInput.getModel().getSize() > 0) {
            if (!(this.getDocument().getDefaultSupportAdapter() instanceof VoidNodeBranchDataAdapter)) {
                this.adapterInput.setSelectedAdapter(this.getDocument().getDefaultSupportAdapter());
            } else if (!this.adapterInput.setSelectedAdapter(TextLabelAdapter.class)) {
                this.adapterInput.setSelectedAdapter(HiddenDataAdapter.class);
            }
            this.pack();
            return true;
        }
        JOptionPane.showMessageDialog(this.getOwner(), "There are no node/branch data columns containing numerical values (e.g. text labels, hidden branch data, ...)\nin this tree. Therefore this feature is currently not available.", "Feature currently not available", 0);
        return false;
    }

    protected boolean apply() {
        double threshold = this.getThreshold();
        if (!Double.isNaN(threshold)) {
            CollapseNodesBySupportEdit edit = new CollapseNodesBySupportEdit(this.getDocument(), this.getSelection().getFirstNodeBranchOrRoot(), this.adapterInput.getSelectedAdapter(), threshold);
            this.getDocument().executeEdit(edit);
            if (edit.hasWarnings()) {
                WikiHelpOptionPane.showMessageDialog((Component)MainFrame.getInstance(), (Object)edit.getWarningText(), (String)"Collapse nodes by support", (int)2, (WikiHelp)Main.getInstance().getWikiHelp(), (int)72);
            }
            return true;
        }
        JOptionPane.showMessageDialog((Component)((Object)this), "The threshold value \"" + this.getThresholdTextField().getText() + "\" is invalid. Please specify a valid numerical value.", "Invalid threshold", 0);
        return false;
    }
}

