/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.view;

import info.bioinfweb.treegraph.gui.actions.view.SetZoomAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeViewPanel;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class SetUserZoomAction
extends SetZoomAction {
    public SetUserZoomAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Set zoom...");
        this.putValue("MnemonicKey", 83);
    }

    @Override
    protected float getZoom(ActionEvent e, TreeInternalFrame frame) {
        TreeViewPanel panel = frame.getTreeViewPanel();
        boolean cancel = false;
        float result = panel.getZoom();
        while (!cancel) {
            String input = JOptionPane.showInputDialog(frame, "Note that you could alternatively use Ctrl + mouse wheel.\n(See the help for details.)\n\nZoom [%]:", "" + panel.getZoom() * 100.0f);
            if (input != null) {
                try {
                    result = Float.parseFloat(input) / 100.0f;
                    cancel = true;
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(frame, "\"" + input + "\" is not a valid floating point value.");
                }
                continue;
            }
            cancel = true;
        }
        return result;
    }
}

