/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.view;

import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintFactory;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintType;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import info.bioinfweb.wikihelp.client.WikiHelp;
import info.bioinfweb.wikihelp.client.WikiHelpOptionPane;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class ChangePainterIDAction
extends DocumentAction {
    private PositionPaintType type = PositionPaintFactory.getDefaultType();

    public ChangePainterIDAction(MainFrame mainFrame, PositionPaintType type) {
        super(mainFrame);
        this.type = type;
        String name = PositionPaintFactory.getInstance().getName(type);
        this.putValue("Name", name);
        this.putValue("SwingDisplayedMnemonicIndexKey", 0);
        this.putValue("ShortDescription", String.valueOf(name) + " view");
        this.loadSymbols("Painter" + name.replaceAll(" ", "").replaceAll("/", ""));
    }

    @Override
    protected void onActionPerformed(ActionEvent e, TreeInternalFrame frame) {
        if (PositionPaintFactory.getInstance().needsBrancheLengths(this.type)) {
            Tree tree = frame.getDocument().getTree();
            if (!Tree.hasAllBranchLengths(tree.getPaintStart(), false)) {
                WikiHelpOptionPane.showMessageDialog((Component)MainFrame.getInstance(), (Object)"Not all branch lengths of the current tree have been specified.\n\nUndefined branches will be displayed as specified by their minimal branch length format. Note that the displayed tree therefore is not a real phylogram or chronogram.", (String)"Missing branch length(s)", (int)2, (WikiHelp)Main.getInstance().getWikiHelp(), (int)29);
            } else if (!tree.isEmpty() && tree.getFormats().getShowRooted() && !tree.getPaintStart().getAfferentBranch().hasLength()) {
                WikiHelpOptionPane.showMessageDialog((Component)MainFrame.getInstance(), (Object)"The root branch length of this tree has not been specified.\n\nIt will be displayed as specified by its minimal branch length format. Note that the displayed tree therefore is not a real phylogram or chronogram.\n\nTo avaid this message you can either specify a root branch length or hide the root branch.", (String)"Missing root branch length", (int)2, (WikiHelp)Main.getInstance().getWikiHelp(), (int)29);
            }
        }
        frame.getTreeViewPanel().setPainterType(this.type);
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(document != null);
    }
}

