/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.select;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.event.ActionEvent;
import java.util.Iterator;

public class TreeSelectionSynchronizeToggleAction
extends DocumentAction {
    public TreeSelectionSynchronizeToggleAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Synchronize tree selection");
        this.putValue("ShortDescription", "Synchronize node selection in all currently opened trees");
        this.putValue("SwingSelectedKey", false);
        this.loadSymbols("SynchronizeTreeSelection");
    }

    public boolean isActive() {
        return (Boolean)this.getValue("SwingSelectedKey");
    }

    @Override
    protected void onActionPerformed(ActionEvent e, TreeInternalFrame frame) {
        Iterator<TreeInternalFrame> treeFrameIterator = this.getMainFrame().treeFrameIterator();
        if (this.isActive()) {
            this.getMainFrame().getTreeSelectionSynchronizer().reset();
            this.getMainFrame().addChildWindowListener(this.getMainFrame().getTreeSelectionSynchronizer());
            while (treeFrameIterator.hasNext()) {
                TreeInternalFrame currentFrame = treeFrameIterator.next();
                currentFrame.getTreeViewPanel().addTreeViewPanelListener(this.getMainFrame().getTreeSelectionSynchronizer());
                currentFrame.getTreeViewPanel().getDocument().addView(this.getMainFrame().getTreeSelectionSynchronizer());
            }
        } else {
            this.getMainFrame().removeChildWindowListener(this.getMainFrame().getTreeSelectionSynchronizer());
            while (treeFrameIterator.hasNext()) {
                TreeInternalFrame currentFrame = treeFrameIterator.next();
                currentFrame.getTreeViewPanel().removeTreeViewPanelListener(this.getMainFrame().getTreeSelectionSynchronizer());
                currentFrame.getTreeViewPanel().getDocument().removeView(this.getMainFrame().getTreeSelectionSynchronizer());
            }
        }
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        Iterator<TreeInternalFrame> iterator = this.getMainFrame().treeFrameIterator();
        int treeCount = 0;
        while (iterator.hasNext()) {
            if (iterator.next().getDocument().getTree().isEmpty() || ++treeCount < 2) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }
}

