/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.select;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.NodeType;
import info.bioinfweb.treegraph.document.PaintableElement;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import info.bioinfweb.treegraph.gui.actions.select.AbstractSelectionAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;

public class SelectTypeInSubtreeAction
extends AbstractSelectionAction {
    public SelectTypeInSubtreeAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Select this type(s) in subtree(s)");
        this.putValue("MnemonicKey", 89);
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(selection != null && !selection.containsOnlyType(Legend.class) && !selection.isEmpty());
    }

    @Override
    protected void performSelection(ActionEvent e, TreeInternalFrame frame, TreeSelection selection) {
        LinkedList<PaintableElement> list = new LinkedList<PaintableElement>();
        for (PaintableElement element : selection) {
            Node root = Tree.getLinkedNode(element);
            if (root == null) continue;
            PaintableElement[] subelements = TreeSerializer.getElementsInSubtree((Node)root, (NodeType)NodeType.BOTH, element.getClass(), (PaintableElement[])new PaintableElement[0]);
            int j = 0;
            while (j < subelements.length) {
                list.add(subelements[j]);
                ++j;
            }
        }
        selection.addAll((Collection<? extends PaintableElement>)list);
    }
}

