/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.select;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Legends;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.gui.actions.select.AbstractSelectionAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.event.ActionEvent;

public class SelectLegendsWithPosIndexAction
extends AbstractSelectionAction {
    public SelectLegendsWithPosIndexAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Select legends with same position index");
        this.putValue("MnemonicKey", 80);
        this.putValue("ShortDescription", "Select legends with the same position index");
    }

    @Override
    protected void performSelection(ActionEvent e, TreeInternalFrame frame, TreeSelection selection) {
        int posIndex = selection.getFirstElementOfType(Legend.class).getFormats().getPosition();
        Legends legends = frame.getDocument().getTree().getLegends();
        int i = 0;
        while (i < legends.size()) {
            if (legends.get(i).getFormats().getPosition() == posIndex) {
                selection.add(legends.get(i));
            }
            ++i;
        }
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(selection != null && selection.containsType(Legend.class));
    }
}

