/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.select;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.PaintableElement;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.TreeElement;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import info.bioinfweb.treegraph.gui.actions.select.AbstractSelectionAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class SelectLegendsInSubtreeAction
extends AbstractSelectionAction {
    public SelectLegendsInSubtreeAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Select legends in subtree(s)");
        this.putValue("MnemonicKey", 69);
        this.putValue("ShortDescription", "Select legends in subtree(s)");
        this.putValue("SwingDisplayedMnemonicIndexKey", 8);
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(selection != null && selection.containsType(TreeElement.class));
    }

    @Override
    protected void performSelection(ActionEvent e, TreeInternalFrame frame, TreeSelection selection) {
        ArrayList<PaintableElement> selectionCopy = new ArrayList<PaintableElement>(selection.size());
        selectionCopy.addAll(selection);
        for (PaintableElement element : selectionCopy) {
            Node root = Tree.getLinkedNode(element);
            if (root == null) continue;
            Legend[] legends = TreeSerializer.getLegendsInSubtree(frame.getDocument().getTree(), root);
            int j = 0;
            while (j < legends.length) {
                selection.add(legends[j]);
                ++j;
            }
        }
    }
}

