/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.select;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.NodeType;
import info.bioinfweb.treegraph.document.PaintableElement;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.TreeElement;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import info.bioinfweb.treegraph.gui.actions.select.AbstractSelectionAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class SelectLeavesInSubtreeAction
extends AbstractSelectionAction {
    public SelectLeavesInSubtreeAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Select leaves in subtree(s)");
        this.putValue("MnemonicKey", 66);
        this.putValue("SwingDisplayedMnemonicIndexKey", 18);
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(selection != null && selection.containsType(TreeElement.class));
    }

    @Override
    protected void performSelection(ActionEvent e, TreeInternalFrame frame, TreeSelection selection) {
        ArrayList<PaintableElement> selectionCopy = new ArrayList<PaintableElement>(selection.size());
        selectionCopy.addAll(selection);
        for (PaintableElement element : selectionCopy) {
            Node root = Tree.getLinkedNode(element);
            if (root == null) continue;
            Node[] subelements = (Node[])TreeSerializer.getElementsInSubtree((Node)root, (NodeType)NodeType.LEAVES, Node.class);
            int j = 0;
            while (j < subelements.length) {
                selection.add(subelements[j]);
                selection.add(subelements[j].getAfferentBranch());
                ++j;
            }
        }
    }
}

