/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.select;

import info.bioinfweb.treegraph.document.AbstractPaintableElement;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Legends;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.NodeType;
import info.bioinfweb.treegraph.document.PaintableElement;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import info.bioinfweb.treegraph.gui.actions.select.AbstractSelectionAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.event.ActionEvent;
import java.util.Vector;

public class InvertSelectionAction
extends AbstractSelectionAction {
    public InvertSelectionAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Invert selection");
        this.putValue("MnemonicKey", 86);
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    @Override
    protected void performSelection(ActionEvent e, TreeInternalFrame frame, TreeSelection selection) {
        Tree tree = frame.getDocument().getTree();
        Vector<AbstractPaintableElement> newSelection = new Vector<AbstractPaintableElement>();
        AbstractPaintableElement[] all = (AbstractPaintableElement[])TreeSerializer.getElementsInSubtree((Node)tree.getPaintStart(), (NodeType)NodeType.BOTH, AbstractPaintableElement.class);
        int i = 0;
        while (i < all.length) {
            if (!selection.contains(all[i])) {
                newSelection.add(all[i]);
            }
            ++i;
        }
        Legends legends = tree.getLegends();
        int i2 = 0;
        while (i2 < legends.size()) {
            if (!selection.contains(legends.get(i2))) {
                newSelection.add(legends.get(i2));
            }
            ++i2;
        }
        if (tree.getFormats().getShowScaleBar() && !selection.contains(tree.getScaleBar())) {
            newSelection.add(tree.getScaleBar());
        }
        selection.clear();
        i2 = 0;
        while (i2 < newSelection.size()) {
            selection.add((PaintableElement)newSelection.get(i2));
            ++i2;
        }
    }
}

