/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.format;

import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.PaintableElement;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.format.ReanchorLegendEdit;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.KeyStroke;

public class ReanchorLegendAction
extends DocumentAction {
    public ReanchorLegendAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Reanchor legend");
        this.putValue("MnemonicKey", 82);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 1 + Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(selection != null && selection.containsType(Legend.class) && selection.containsType(Node.class) && selection.elementCount(Node.class) <= 2 && !selection.containsType(Branch.class) && !selection.containsType(Label.class));
    }

    @Override
    protected void onActionPerformed(ActionEvent e, TreeInternalFrame frame) {
        TreeSelection selection = frame.getTreeViewPanel().getSelection();
        Node upperAnchor = selection.getFirstElementOfType(Node.class);
        String lowerAnchorName = null;
        if (selection.size() == 3) {
            Iterator<PaintableElement> iterator = selection.iterator();
            while (iterator.hasNext() && lowerAnchorName == null) {
                PaintableElement element = iterator.next();
                if (!(element instanceof Node) || element == upperAnchor) continue;
                lowerAnchorName = ((Node)element).getUniqueName();
            }
        }
        frame.getDocument().executeEdit(new ReanchorLegendEdit(frame.getDocument(), selection.getFirstElementOfType(Legend.class), upperAnchor.getUniqueName(), lowerAnchorName));
    }
}

