/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.format;

import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.NodeType;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.tools.IDManager;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import info.bioinfweb.treegraph.document.undo.format.AutoPositionLabelsEdit;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JOptionPane;

public class AutoPositionLabelsAction
extends DocumentAction {
    public AutoPositionLabelsAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Automatically position labels");
        this.putValue("MnemonicKey", 65);
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(document != null && !document.getTree().isEmpty() && selection != null && (selection.isEmpty() || selection.containsOnlyType(Branch.class)));
    }

    private boolean containsSupportConflictIDs(Document document) {
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(IDManager.getLabelIDs(document.getTree().getPaintStart(), Label.class)));
        for (String id : ids) {
            if (!id.endsWith("Support") || !ids.contains(id.replace("Support", "Conflict"))) continue;
            return true;
        }
        return false;
    }

    private boolean getEqualSupportConflictPosition(Document document) {
        if (this.containsSupportConflictIDs(document)) {
            return JOptionPane.showConfirmDialog(this.getMainFrame(), "This document contains pairs of label IDs which seem to be comming from the add support values feature\nof TreeGraph (e.g. \"XXXSupport\" and \"XXXConflict\").\n\nDo you want both label columns to have the same position?\n\n(\"Yes\" is recommended because usually both types of labels won't occur on the same branch. Select \"No\" if\nthese labels have a different source and you expect both support and conflict labels to occur on the same branch.)", "Treatment of support and conflict labels", 0, 3) == 0;
        }
        return false;
    }

    @Override
    protected void onActionPerformed(ActionEvent e, TreeInternalFrame frame) {
        TreeSelection selection = frame.getTreeViewPanel().getSelection();
        Branch[] branches = selection.isEmpty() ? (Branch[])TreeSerializer.getElementsInSubtree((Node)frame.getDocument().getTree().getPaintStart(), (NodeType)NodeType.BOTH, Branch.class) : selection.toArray(new Branch[selection.size()]);
        frame.getDocument().executeEdit(new AutoPositionLabelsEdit(frame.getDocument(), branches, this.getEqualSupportConflictPosition(frame.getDocument())));
    }
}

