/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.file;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.nodebranchdata.NewHiddenBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.file.importtable.DuplicateKeyException;
import info.bioinfweb.treegraph.document.undo.file.importtable.ImportTableData;
import info.bioinfweb.treegraph.document.undo.file.importtable.ImportTableEdit;
import info.bioinfweb.treegraph.document.undo.file.importtable.ImportTableParameters;
import info.bioinfweb.treegraph.document.undo.file.importtable.InsufficientTableSizeException;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.treegraph.gui.dialogs.io.imexporttable.KeyColumnDialog;
import info.bioinfweb.treegraph.gui.dialogs.io.imexporttable.SelectImportTableDialog;
import info.bioinfweb.treegraph.gui.dialogs.nodebranchdata.NodeBranchDataColumnsDialog;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class ImportTableAction
extends DocumentAction {
    public static final String PARAMETER_MESSAGE = "Note that the parameter settings (e.g. whitespace treatment, case sensitivity)\ninfluences if two entries are considered equal.";
    private SelectImportTableDialog importTableDialog = null;
    private NodeBranchDataColumnsDialog assignImportColumnsDialog = null;
    private KeyColumnDialog keyColumnDialog = null;

    public ImportTableAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Import table as node/branch data...");
        this.putValue("MnemonicKey", 73);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(120, 1));
    }

    private SelectImportTableDialog getImportTableDialog() {
        if (this.importTableDialog == null) {
            this.importTableDialog = new SelectImportTableDialog(this.getMainFrame());
        }
        return this.importTableDialog;
    }

    private NodeBranchDataColumnsDialog getAssignImportColumnsDialog() {
        if (this.assignImportColumnsDialog == null) {
            this.assignImportColumnsDialog = new NodeBranchDataColumnsDialog((Frame)this.getMainFrame(), "Import table as node/branch data", 89);
        }
        return this.assignImportColumnsDialog;
    }

    private KeyColumnDialog getKeyColumnDialog() {
        if (this.keyColumnDialog == null) {
            this.keyColumnDialog = new KeyColumnDialog(this.getMainFrame());
        }
        return this.keyColumnDialog;
    }

    private boolean showImportColumnsDialog(Document document, ImportTableParameters parameters, ImportTableData data) {
        boolean[] allowEdit = new boolean[data.columnCount()];
        int i = 0;
        while (i < allowEdit.length) {
            allowEdit[i] = true;
            ++i;
        }
        allowEdit[data.getKeyColumnIndex()] = false;
        NodeBranchDataAdapter[] adapters = new NodeBranchDataAdapter[data.columnCount()];
        int i2 = 0;
        while (i2 < adapters.length) {
            if (i2 == data.getKeyColumnIndex()) {
                adapters[i2] = parameters.getKeyAdapter();
            } else {
                String heading = data.getHeading(i2);
                if (heading.isEmpty()) {
                    heading = "Column " + i2;
                }
                adapters[i2] = new NewHiddenBranchDataAdapter(heading);
            }
            ++i2;
        }
        boolean result = this.getAssignImportColumnsDialog().execute(document.getTree(), adapters, null, allowEdit, "Do not import this column");
        if (result) {
            parameters.setImportAdapters(adapters);
        }
        return result;
    }

    @Override
    protected void onActionPerformed(ActionEvent e, TreeInternalFrame frame) {
        if (this.getImportTableDialog().execute(frame.getDocument(), frame.getTreeViewPanel().getSelection(), frame.getSelectedAdapter())) {
            ImportTableParameters parameters = new ImportTableParameters();
            this.getImportTableDialog().assignParameters(parameters);
            try {
                ImportTableData data = new ImportTableData(parameters);
                if (data != null && this.getKeyColumnDialog().execute(frame.getDocument(), data)) {
                    this.getKeyColumnDialog().assignParameters(parameters);
                    data.processKeyColumn(this.getKeyColumnDialog().getSelectedTableKeyColumn(), parameters);
                    if (this.showImportColumnsDialog(frame.getDocument(), parameters, data)) {
                        ImportTableEdit edit = new ImportTableEdit(frame.getDocument(), parameters, data);
                        frame.getDocument().executeEdit(edit);
                        if (edit.hasWarnings()) {
                            JOptionPane.showMessageDialog(MainFrame.getInstance(), edit.getWarningText(), "Warning", 2);
                        }
                    }
                }
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "The file \"" + parameters.getTableFile().getAbsolutePath() + "\" was not found.", "Error", 0);
            }
            catch (SecurityException ex) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "The permission for writing to the file \"" + parameters.getTableFile().getAbsolutePath() + "\" was denied.", "Error", 0);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "The error \"" + ex.getMessage() + "\" occured when writing to the file \"" + parameters.getTableFile().getAbsolutePath() + "\".", "Error", 0);
            }
            catch (DuplicateKeyException ex) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "The first column of the imported table file (keys to identify nodes) contained the\nfollowing entries multiple times:\n\n" + ImportTableAction.createElementList(ex.getKeys(), true) + "\n\n" + PARAMETER_MESSAGE, "Error", 0);
            }
            catch (InsufficientTableSizeException ex) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), ex.getMessage(), "Error", 0);
            }
        }
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(document != null && !document.getTree().isEmpty());
    }
}

