/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.file;

import info.bioinfweb.commons.progress.ProgressMonitor;
import info.bioinfweb.commons.swing.ProgressDialog;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.io.ancestralstate.BayesTraitsReader;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.file.ancestralstate.AncestralStateImportParameters;
import info.bioinfweb.treegraph.document.undo.file.ancestralstate.ImportBayesTraitsDataEdit;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.treegraph.gui.dialogs.io.ancestralstate.AssignBayesTraitsImportColumnsDialog;
import info.bioinfweb.treegraph.gui.dialogs.io.ancestralstate.ImportBayesTraitsDataDialog;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

public class ImportBayesTraitsDataAction
extends DocumentAction {
    private ImportBayesTraitsDataDialog importBayesTraitsDataDialog = null;
    private AssignBayesTraitsImportColumnsDialog assignBayesTraitsImportColumnsDialog = null;

    public ImportBayesTraitsDataAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Import BayesTraits data...");
        this.putValue("MnemonicKey", 66);
    }

    private ImportBayesTraitsDataDialog getImportBayesTraitsDataDialog() {
        if (this.importBayesTraitsDataDialog == null) {
            this.importBayesTraitsDataDialog = new ImportBayesTraitsDataDialog(this.getMainFrame());
        }
        return this.importBayesTraitsDataDialog;
    }

    private AssignBayesTraitsImportColumnsDialog getAssignBayesTraitsImportColumnsDialog() {
        if (this.assignBayesTraitsImportColumnsDialog == null) {
            this.assignBayesTraitsImportColumnsDialog = new AssignBayesTraitsImportColumnsDialog(this.getMainFrame());
        }
        return this.assignBayesTraitsImportColumnsDialog;
    }

    @Override
    protected void onActionPerformed(ActionEvent e, final TreeInternalFrame frame) {
        if (this.getImportBayesTraitsDataDialog().execute(frame.getDocument(), frame.getTreeViewPanel().getSelection(), frame.getSelectedAdapter())) {
            AncestralStateImportParameters parameters = new AncestralStateImportParameters();
            this.getImportBayesTraitsDataDialog().assignParameters(parameters);
            try {
                BayesTraitsReader bayesTraitsReader = new BayesTraitsReader();
                parameters.setData(bayesTraitsReader.read(parameters.getTableFile().getAbsolutePath()));
                if (this.getAssignBayesTraitsImportColumnsDialog().execute(parameters, parameters.getData().get("Root"), frame.getDocument().getTree())) {
                    final ProgressDialog progressDialog = new ProgressDialog((Window)this.getMainFrame(), "Importing data...", null, true, null);
                    final ImportBayesTraitsDataEdit edit = new ImportBayesTraitsDataEdit(frame.getDocument(), parameters, (ProgressMonitor)progressDialog);
                    new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            frame.getDocument().executeEdit(edit);
                            return null;
                        }

                        @Override
                        protected void done() {
                            progressDialog.dispose();
                            if (edit.hasWarnings()) {
                                JOptionPane.showMessageDialog(MainFrame.getInstance(), edit.getWarningText(), "Warning", 2);
                            }
                        }
                    }.execute();
                    progressDialog.setVisible(true);
                }
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "The file \"" + parameters.getTableFile().getAbsolutePath() + "\" was not found.", "Error", 0);
            }
            catch (SecurityException ex) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "The permission for writing to the file \"" + parameters.getTableFile().getAbsolutePath() + "\" was denied.", "Error", 0);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "The error \"" + ex.getMessage() + "\" occured when writing to the file \"" + parameters.getTableFile().getAbsolutePath() + "\".", "Error", 0);
            }
        }
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(document != null && !document.getTree().isEmpty());
    }
}

