/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.file;

import info.bioinfweb.commons.collections.ParameterMap;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.graphics.export.GraphicFormat;
import info.bioinfweb.treegraph.graphics.export.GraphicWriterFactory;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintFactory;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;

public class ExportToPDFAction
extends DocumentAction {
    public static final String FILE_PREFIX = "Tree";
    public static final String FILE_SUFFIX = ".pdf";

    public ExportToPDFAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Export to PDF");
        this.putValue("ShortDescription", "Export to PDF");
        this.loadSymbols("PDF");
    }

    @Override
    protected void onActionPerformed(ActionEvent e, TreeInternalFrame frame) {
        if (Desktop.isDesktopSupported()) {
            try {
                File file = File.createTempFile(FILE_PREFIX, FILE_SUFFIX);
                ParameterMap hints = new ParameterMap();
                hints.put("dimensionsInPixels", true);
                GraphicWriterFactory.getInstance().getWriter(GraphicFormat.PDF).write(frame.getDocument(), PositionPaintFactory.getInstance().getPainter(frame.getTreeViewPanel().getPainterType()), hints, file);
                Desktop.getDesktop().open(file);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "The error \"" + ex.getMessage() + "\" occured when trying to create the PDF file.", "IO Error", 0);
            }
        } else {
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "Your system does not support this function. Use \"File\" -> \"Export to graphic/PDF...\" instead.", "Function not supported", 0);
        }
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(document != null);
    }
}

