/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.file;

import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.PieChartLabel;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import info.bioinfweb.treegraph.gui.CurrentDirectoryModel;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ExportPieChartLabelColorsAction
extends DocumentAction {
    private JFileChooser fileChooser = null;
    private FileNameExtensionFilter textFilter;

    public ExportPieChartLabelColorsAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Export pie chart label colors...");
        this.putValue("ShortDescription", "Export pie chart label colors");
    }

    private void writeTable(File file, Branch branch) throws FileNotFoundException {
        try (PrintWriter writer = new PrintWriter(file);){
            PieChartLabel[] labels;
            writer.println("Pie chart label ID\tCharacter name\tSource data column ID\tState name\tColor\tRed\tGreen\tBlue");
            PieChartLabel[] pieChartLabelArray = labels = (PieChartLabel[])TreeSerializer.getElementsOnNode((Node)branch.getTargetNode(), PieChartLabel.class);
            int n = labels.length;
            int n2 = 0;
            while (n2 < n) {
                PieChartLabel label = pieChartLabelArray[n2];
                int i = 0;
                while (i < label.getSectionDataList().size()) {
                    writer.write(label.getID());
                    writer.write(9);
                    writer.write(label.getData().formatValue(label.getFormats().getDecimalFormat()));
                    writer.write(9);
                    writer.write(label.getSectionDataList().get(i).getValueColumnID());
                    writer.write(9);
                    writer.write(label.getSectionDataList().get(i).getCaption());
                    writer.write(9);
                    Color color = label.getFormats().getPieColor(i);
                    writer.write(String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue()));
                    writer.write(9);
                    writer.print(color.getRed());
                    writer.write(9);
                    writer.print(color.getGreen());
                    writer.write(9);
                    writer.print(color.getBlue());
                    writer.write(9);
                    writer.println();
                    ++i;
                }
                ++n2;
            }
        }
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setDialogType(1);
            this.fileChooser.setDialogTitle("Export pie chart label colors");
            this.fileChooser.setMultiSelectionEnabled(false);
            this.textFilter = new FileNameExtensionFilter("Text files (*.txt)", "txt");
            this.fileChooser.setFileFilter(this.textFilter);
            CurrentDirectoryModel.getInstance().addFileChooser(this.fileChooser);
        }
        return this.fileChooser;
    }

    @Override
    protected void onActionPerformed(ActionEvent e, TreeInternalFrame frame) {
        if (this.getFileChooser().showSaveDialog(this.getMainFrame()) == 0) {
            File file = this.getFileChooser().getSelectedFile();
            if (this.textFilter.equals(this.getFileChooser().getFileFilter())) {
                String extension = "." + this.textFilter.getExtensions()[0];
                if (!file.getAbsolutePath().endsWith(extension)) {
                    file = new File(String.valueOf(file.getAbsolutePath()) + extension);
                }
            }
            if (!file.exists() || JOptionPane.showConfirmDialog(this.getMainFrame(), "The file \"" + file.getAbsolutePath() + "\" already exists.\nDo you want to overwrite it?", "Overwrite table file", 0, 2) == 0) {
                try {
                    this.writeTable(file, frame.getTreeViewPanel().getSelection().getFirstElementOfType(Branch.class));
                }
                catch (IOException | SecurityException ex) {
                    JOptionPane.showMessageDialog(this.getMainFrame(), "The error \"" + ex.getLocalizedMessage() + "\"\n occurred when trying to write the file \"" + file.getAbsolutePath() + "\".", "Error when writing file", 0);
                }
            }
        }
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(ExportPieChartLabelColorsAction.oneElementSelected(selection) && selection.containsType(Branch.class) && selection.getFirstElementOfType(Branch.class).getLabels().contains(PieChartLabel.class));
    }
}

