/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.file;

import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.PieChartLabel;
import info.bioinfweb.treegraph.document.TextElementData;
import info.bioinfweb.treegraph.document.TextLabel;
import info.bioinfweb.treegraph.document.format.PieChartLabelCaptionContentType;
import info.bioinfweb.treegraph.document.format.PieChartLabelFormats;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.tools.IDManager;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.event.ActionEvent;

public class CreateBranchLabelCaptionDocumentAction
extends DocumentAction {
    public static final String SOURCE_DATA_COLUMN_ID = "pieChartSource";

    public CreateBranchLabelCaptionDocumentAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Create label caption document");
        this.putValue("ShortDescription", "Create a document with label captions of the selected branch.");
    }

    private void editPieChartLabel(PieChartLabel label, String sourceDataID) {
        TextElementData title = label.getData();
        if (title.isEmpty() || title.isString() && title.getText().isEmpty()) {
            title.setText(label.getID());
        }
        for (PieChartLabel.SectionData data : label.getSectionDataList()) {
            if (data.getCaption() == null || data.getCaption().isEmpty()) {
                data.setCaption(data.getValueColumnID());
            }
            data.setValueColumnID(sourceDataID);
            PieChartLabelFormats f = label.getFormats();
            f.setShowTitle(true);
            if (!PieChartLabelCaptionContentType.NONE.equals((Object)f.getCaptionsContentType())) continue;
            f.setCaptionsContentType(PieChartLabelCaptionContentType.CAPTIONS);
        }
    }

    @Override
    protected void onActionPerformed(ActionEvent e, TreeInternalFrame frame) {
        Label[] labels;
        Branch sourceBranch = frame.getTreeViewPanel().getSelection().getFirstElementOfType(Branch.class);
        Document d = new Document();
        Node root = new Node();
        root.setAfferentBranch(sourceBranch.clone());
        d.getTree().setPaintStart(root);
        String sourceDataID = IDManager.newID(SOURCE_DATA_COLUMN_ID, IDManager.getIDListFromSubtree(root));
        root.getHiddenDataMap().put(sourceDataID, new TextElementData(1.0));
        Label[] labelArray = labels = (Label[])TreeSerializer.getElementsOnNode((Node)root, Label.class);
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            Label label = labelArray[n2];
            if (label instanceof TextLabel) {
                ((TextLabel)label).getData().setText(label.getID());
            }
            if (label instanceof PieChartLabel) {
                this.editPieChartLabel((PieChartLabel)label, sourceDataID);
            }
            ++n2;
        }
        d.getTree().updateElementSet();
        this.getMainFrame().addInternalFrame(d);
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(CreateBranchLabelCaptionDocumentAction.oneElementSelected(selection) && selection.containsType(Branch.class) && !selection.getFirstElementOfType(Branch.class).getLabels().isEmpty());
    }
}

