/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.file;

import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.file.AddSupportValuesEdit;
import info.bioinfweb.treegraph.document.undo.file.AddSupportValuesParameters;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.treegraph.gui.dialogs.io.AddSupportValueColumnsDialog;
import info.bioinfweb.treegraph.gui.dialogs.io.AddSupportValuesDialog;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import info.bioinfweb.wikihelp.client.WikiHelp;
import info.bioinfweb.wikihelp.client.WikiHelpOptionPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class AddSupportValuesAction
extends DocumentAction {
    private AddSupportValuesDialog addSupportValuesDialog;
    private AddSupportValueColumnsDialog addSupportValueColumnsDialog;

    public AddSupportValuesAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Add support values...");
        this.putValue("MnemonicKey", 86);
        this.putValue("ShortDescription", "Add support values from other tree");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(120, 0));
    }

    @Override
    protected void onActionPerformed(ActionEvent e, TreeInternalFrame frame) {
        if (this.getAddSupportValuesDialog().execute(frame.getDocument(), frame.getTreeViewPanel().getSelection(), frame.getSelectedAdapter())) {
            AddSupportValuesParameters addSupportValuesParameters = new AddSupportValuesParameters();
            if (this.getAddSupportValuesDialog().assignParameters(addSupportValuesParameters) && this.getAddSupportValueColumnsDialog().execute(addSupportValuesParameters, addSupportValuesParameters.getSourceDocument().getTree())) {
                AddSupportValuesEdit edit = new AddSupportValuesEdit(frame.getDocument(), addSupportValuesParameters);
                frame.getDocument().executeEdit(edit);
                if (edit.hasWarnings()) {
                    WikiHelpOptionPane.showMessageDialog((Component)MainFrame.getInstance(), (Object)edit.getWarningText(), (String)"Some leaf nodes did not match", (int)2, (WikiHelp)Main.getInstance().getWikiHelp(), (int)86);
                }
            }
        }
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(document != null && !document.getTree().isEmpty());
    }

    private AddSupportValuesDialog getAddSupportValuesDialog() {
        if (this.addSupportValuesDialog == null) {
            this.addSupportValuesDialog = new AddSupportValuesDialog(this.getMainFrame());
        }
        return this.addSupportValuesDialog;
    }

    private AddSupportValueColumnsDialog getAddSupportValueColumnsDialog() {
        if (this.addSupportValueColumnsDialog == null) {
            this.addSupportValueColumnsDialog = new AddSupportValueColumnsDialog(this.getMainFrame());
        }
        return this.addSupportValueColumnsDialog;
    }
}

