/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Labels;
import info.bioinfweb.treegraph.document.Legends;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextElement;
import info.bioinfweb.treegraph.document.TextLabel;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.edit.ReplaceInNodeDataEdit;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.treegraph.gui.dialogs.SearchTextDialog;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class SearchTextAction
extends DocumentAction {
    private SearchTextDialog dialog;
    private TreeSelection selection;
    private Pattern pattern;

    public SearchTextAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Search text...");
        this.putValue("SwingDisplayedMnemonicIndexKey", 7);
        this.putValue("MnemonicKey", 84);
        this.putValue("ShortDescription", "Search text");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.loadSymbols("Search");
        this.dialog = new SearchTextDialog(mainFrame);
    }

    private boolean matches(TextElement element) {
        return this.pattern.matcher(element.getData().formatValue(element.getFormats().getDecimalFormat())).find();
    }

    private void searchLabelBlock(Labels labels, boolean above) {
        int lineIndex = 0;
        while (lineIndex < labels.lineCount(above)) {
            int linePos = 0;
            while (linePos < labels.labelCount(above, lineIndex)) {
                Label label = labels.get(above, lineIndex, linePos);
                if (label instanceof TextLabel && this.matches((TextLabel)label)) {
                    this.selection.add(label);
                }
                ++linePos;
            }
            ++lineIndex;
        }
    }

    private void searchSubtree(Node root) {
        if ((root.isLeaf() || this.dialog.includeInternalNodeNames()) && this.matches(root)) {
            this.selection.add(root);
        }
        this.searchLabelBlock(root.getAfferentBranch().getLabels(), true);
        this.searchLabelBlock(root.getAfferentBranch().getLabels(), false);
        int i = 0;
        while (i < root.getChildren().size()) {
            this.searchSubtree(root.getChildren().get(i));
            ++i;
        }
    }

    private void searchLegends(Legends legends) {
        int i = 0;
        while (i < legends.size()) {
            if (this.matches(legends.get(i))) {
                this.selection.add(legends.get(i));
            }
            ++i;
        }
    }

    private void searchScaleBar(Tree tree) {
        if (tree.getFormats().getShowScaleBar() && this.matches(tree.getScaleBar())) {
            this.selection.add(tree.getScaleBar());
        }
    }

    @Override
    protected void onActionPerformed(ActionEvent e, TreeInternalFrame frame) {
        this.selection = frame.getTreeViewPanel().getSelection();
        if (this.dialog.execute(frame.getDocument(), this.selection, frame.getSelectedAdapter())) {
            this.selection.clear();
            this.pattern = ReplaceInNodeDataEdit.generatePattern(this.dialog.getText(), this.dialog.caseSensitive(), this.dialog.wordsOnly());
            Tree tree = frame.getDocument().getTree();
            this.searchSubtree(tree.getPaintStart());
            this.searchLegends(tree.getLegends());
            this.searchScaleBar(tree);
            if (this.selection.isEmpty()) {
                JOptionPane.showMessageDialog(null, "No elements were found.", "No results", 1);
            }
        }
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(document != null && (!document.getTree().isEmpty() || !document.getTree().getLegends().isEmpty()));
    }
}

