/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.edit;

import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.PaintableElement;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.edit.RerootByLeafSetEdit;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import info.bioinfweb.wikihelp.client.WikiHelp;
import info.bioinfweb.wikihelp.client.WikiHelpOptionPane;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.KeyStroke;

public class RerootByLeafSetAction
extends DocumentAction {
    public RerootByLeafSetAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Root by leaves");
        this.putValue("MnemonicKey", 82);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    @Override
    protected void onActionPerformed(ActionEvent e, TreeInternalFrame frame) {
        TreeSelection selection = frame.getTreeViewPanel().getSelection();
        RerootByLeafSetEdit edit = new RerootByLeafSetEdit(frame.getDocument(), selection.toArray(new Node[selection.size()]));
        frame.getDocument().executeEdit(edit);
        if (edit.hasWarnings()) {
            WikiHelpOptionPane.showMessageDialog((Component)MainFrame.getInstance(), (Object)edit.getWarningText(), (String)"Reroot", (int)2, (WikiHelp)Main.getInstance().getWikiHelp(), (int)70);
        }
        if (!edit.getAlternativeRootingPoints().isEmpty()) {
            selection.clear();
            selection.addAll((Collection<? extends PaintableElement>)edit.getAlternativeRootingPoints());
            WikiHelpOptionPane.showMessageDialog((Component)MainFrame.getInstance(), (Object)"More than one smallest subtree containing all the specified terminal nodes was found.\nThe alternative rooting positions have been selected in the document. Use the \"Root here\" function\nto root at another possible rooting point.", (String)"Multiple optimal rooting points", (int)2, (WikiHelp)Main.getInstance().getWikiHelp(), (int)68);
        }
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(selection != null && selection.containsOnlyLeafNodes());
    }
}

