/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.edit;

import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.edit.RerootEdit;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import info.bioinfweb.wikihelp.client.WikiHelp;
import info.bioinfweb.wikihelp.client.WikiHelpOptionPane;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class RerootAction
extends DocumentAction {
    public RerootAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Root here");
        this.putValue("MnemonicKey", 72);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    @Override
    protected void onActionPerformed(ActionEvent e, TreeInternalFrame frame) {
        RerootEdit edit = new RerootEdit(frame.getDocument(), (Branch)frame.getTreeViewPanel().getSelection().first());
        frame.getDocument().executeEdit(edit);
        if (edit.hasWarnings()) {
            WikiHelpOptionPane.showMessageDialog((Component)MainFrame.getInstance(), (Object)edit.getWarningText(), (String)"Reroot", (int)2, (WikiHelp)Main.getInstance().getWikiHelp(), (int)27);
        }
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        Branch b;
        boolean enabled;
        boolean bl = enabled = RerootAction.oneElementSelected(selection) && selection.containsType(Branch.class);
        if (enabled && (enabled = (b = (Branch)selection.first()).getTargetNode().hasParent())) {
            enabled = b.getTargetNode().getParent().getChildren().size() > 2 || b.getTargetNode().getParent().hasParent();
        }
        this.setEnabled(enabled);
    }
}

