/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.edit;

import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.ContrastManager;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.PaintableElement;
import info.bioinfweb.treegraph.document.clipboard.ClipboardContentType;
import info.bioinfweb.treegraph.document.clipboard.TreeClipboard;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.DocumentEdit;
import info.bioinfweb.treegraph.document.undo.edit.PasteAllLabelsEdit;
import info.bioinfweb.treegraph.document.undo.edit.PasteLabelEdit;
import info.bioinfweb.treegraph.document.undo.edit.PasteLegendEdit;
import info.bioinfweb.treegraph.document.undo.edit.PasteRootEdit;
import info.bioinfweb.treegraph.document.undo.edit.PasteSiblingEdit;
import info.bioinfweb.treegraph.document.undo.edit.PasteSubtreeEdit;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.treegraph.gui.dialogs.CollidingIDsDialog;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.KeyStroke;

public class PasteAction
extends DocumentAction {
    private ContrastManager contrastManager = new ContrastManager();

    public PasteAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Paste");
        this.putValue("MnemonicKey", 80);
        this.putValue("ShortDescription", "Paste");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.loadSymbols("Paste");
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        TreeClipboard clipboard = Main.getInstance().getClipboard();
        boolean pasteNode = document != null && document.getTree().isEmpty() && clipboard.getContentType().equals((Object)ClipboardContentType.SUBTREE);
        boolean pasteLabel = false;
        boolean pasteLegend = false;
        if (selection != null) {
            switch (selection.size()) {
                case 1: {
                    pasteNode = pasteNode || (selection.containsType(Node.class) || selection.containsType(Branch.class)) && clipboard.getContentType().equals((Object)ClipboardContentType.SUBTREE);
                    pasteLabel = selection.containsType(Branch.class) && (clipboard.getContentType().equals((Object)ClipboardContentType.LABEL) || clipboard.getContentType().equals((Object)ClipboardContentType.LABELS));
                    pasteLegend = selection.containsType(Node.class) && clipboard.getContentType().equals((Object)ClipboardContentType.LEGEND);
                    break;
                }
                case 2: {
                    pasteLegend = selection.containsOnlyType(Node.class) && clipboard.getContentType().equals((Object)ClipboardContentType.LEGEND);
                }
            }
        }
        this.setEnabled(pasteNode || pasteLabel || pasteLegend);
    }

    @Override
    protected void onActionPerformed(ActionEvent e, TreeInternalFrame frame) {
        PaintableElement selected = null;
        if (!frame.getDocument().getTree().isEmpty()) {
            selected = frame.getTreeViewPanel().getSelection().first();
        }
        TreeClipboard clipboard = Main.getInstance().getClipboard();
        DocumentEdit edit = null;
        switch (clipboard.getContentType()) {
            case SUBTREE: {
                Node root = clipboard.getSubtree();
                Legend[] legends = clipboard.getSubtreeLegends();
                if (!this.contrastManager.ensureContrast(frame.getDocument(), root, legends)) break;
                if (selected instanceof Node) {
                    edit = new PasteSubtreeEdit(frame.getDocument(), (Node)selected, root, legends);
                    break;
                }
                if (selected instanceof Branch) {
                    edit = new PasteSiblingEdit(frame.getDocument(), ((Branch)selected).getTargetNode(), root, legends);
                    break;
                }
                edit = new PasteRootEdit(frame.getDocument(), root, legends);
                break;
            }
            case LABEL: {
                Label label = clipboard.getLabel();
                if (!this.contrastManager.ensureContrast(frame.getDocument(), label)) break;
                label.setID(CollidingIDsDialog.getInstance().checkConflicts(new Branch[]{(Branch)selected}, label.getID()));
                edit = new PasteLabelEdit(frame.getDocument(), (Branch)selected, label);
                break;
            }
            case LABELS: {
                Label[] labels = clipboard.getLabelList();
                if (!this.contrastManager.ensureContrast(frame.getDocument(), labels)) break;
                ArrayList<String> reservedIDs = new ArrayList<String>(labels.length);
                int i = 0;
                while (i < labels.length) {
                    labels[i].setID(CollidingIDsDialog.getInstance().checkConflicts(new Branch[]{(Branch)selected}, labels[i].getID(), reservedIDs));
                    reservedIDs.add(labels[i].getID());
                    ++i;
                }
                edit = new PasteAllLabelsEdit(frame.getDocument(), (Branch)selected, labels);
                break;
            }
            case LEGEND: {
                Legend legend = clipboard.getLegend();
                if (!this.contrastManager.ensureContrast(frame.getDocument(), legend)) break;
                Node anchor2 = null;
                if (frame.getTreeViewPanel().getSelection().size() > 1) {
                    Iterator<PaintableElement> iterator = frame.getTreeViewPanel().getSelection().iterator();
                    iterator.next();
                    anchor2 = (Node)iterator.next();
                }
                edit = new PasteLegendEdit(frame.getDocument(), (Node)selected, anchor2, legend);
            }
        }
        if (edit != null) {
            frame.getDocument().executeEdit(edit);
        }
    }
}

