/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.edit;

import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.format.FormatUtils;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.edit.InsertSiblingEdit;
import info.bioinfweb.treegraph.document.undo.edit.InsertSubtreeEdit;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class NewNodeAction
extends DocumentAction {
    public NewNodeAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "New node");
        this.putValue("MnemonicKey", 78);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(document != null && document.getTree().isEmpty() || NewNodeAction.oneElementSelected(selection) && (selection.containsType(Node.class) || selection.containsType(Branch.class)));
    }

    public static boolean insertSubtree(Document document, Node parent, Node root) {
        int index = 0;
        if (parent != null) {
            index = parent.getChildren().size();
        }
        return NewNodeAction.insertSubtree(document, parent, root, index);
    }

    public static boolean insertSubtree(Document document, Node parent, Node root, int index) {
        if (parent == null && !document.getTree().isEmpty()) {
            return false;
        }
        InsertSubtreeEdit edit = new InsertSubtreeEdit(document, parent, root, index);
        document.executeEdit(edit);
        return true;
    }

    @Override
    protected void onActionPerformed(ActionEvent e, TreeInternalFrame frame) {
        if (frame.getTreeViewPanel().getSelection().containsType(Branch.class)) {
            Node parent = ((Branch)frame.getTreeViewPanel().getSelection().first()).getTargetNode();
            frame.getDocument().executeEdit(new InsertSiblingEdit(frame.getDocument(), parent, FormatUtils.createNode(parent)));
        } else if (frame.getDocument().getTree().isEmpty()) {
            Node node = FormatUtils.createNode(frame.getDocument());
            if (NewNodeAction.insertSubtree(frame.getDocument(), null, node)) {
                frame.getTreeViewPanel().getSelection().set(node);
            }
        } else {
            Node parent = (Node)frame.getTreeViewPanel().getSelection().first();
            Node node = FormatUtils.createNode(parent);
            if (NewNodeAction.insertSubtree(frame.getDocument(), parent, node)) {
                frame.getTreeViewPanel().getSelection().set(node);
            }
        }
    }
}

