/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.edit;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.PaintableElement;
import info.bioinfweb.treegraph.document.format.FormatUtils;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.edit.InsertLegendEdit;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.KeyStroke;

public class NewLegendAction
extends DocumentAction {
    public NewLegendAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "New legend");
        this.putValue("MnemonicKey", 78);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(selection != null && (selection.size() == 1 || selection.size() == 2) && selection.containsOnlyType(Node.class));
    }

    @Override
    protected void onActionPerformed(ActionEvent e, TreeInternalFrame frame) {
        TreeSelection selection = frame.getTreeViewPanel().getSelection();
        Iterator<PaintableElement> iterator = selection.iterator();
        Node upperAnchor = (Node)iterator.next();
        Node lowerAnchor = null;
        if (selection.size() == 2) {
            lowerAnchor = (Node)iterator.next();
        }
        Legend legend = FormatUtils.createLegend(upperAnchor, frame.getDocument().getTree().getLegends());
        legend.getData().assign(upperAnchor.getData());
        frame.getDocument().executeEdit(new InsertLegendEdit(frame.getDocument(), legend, upperAnchor, lowerAnchor));
    }
}

