/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.edit;

import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Legend;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.PaintableElement;
import info.bioinfweb.treegraph.document.ScaleBar;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class CopyElementAction
extends DocumentAction {
    public CopyElementAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Copy");
        this.putValue("MnemonicKey", 67);
        this.putValue("ShortDescription", "Copy");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.loadSymbols("CopyElement");
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        this.setEnabled(CopyElementAction.oneElementSelected(selection) && !selection.containsType(ScaleBar.class));
    }

    @Override
    protected void onActionPerformed(ActionEvent e, TreeInternalFrame frame) {
        PaintableElement selected = frame.getTreeViewPanel().getSelection().first();
        if (selected instanceof Node) {
            Main.getInstance().getClipboard().copySubtree(frame.getDocument().getTree(), (Node)selected);
        } else if (selected instanceof Branch) {
            Main.getInstance().getClipboard().copySubtree(frame.getDocument().getTree(), ((Branch)selected).getTargetNode());
        } else if (selected instanceof Label) {
            Main.getInstance().getClipboard().copyLabel((Label)selected);
        } else if (selected instanceof Legend) {
            Main.getInstance().getClipboard().copyLegend((Legend)selected);
        }
        MainFrame.getInstance().getActionManagement().refreshActionStatus();
    }
}

