/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions.edit;

import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.undo.edit.CollapseNodeEdit;
import info.bioinfweb.treegraph.gui.actions.DocumentAction;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import info.bioinfweb.wikihelp.client.WikiHelp;
import info.bioinfweb.wikihelp.client.WikiHelpOptionPane;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class CollapseNodeAction
extends DocumentAction {
    public CollapseNodeAction(MainFrame mainFrame) {
        super(mainFrame);
        this.putValue("Name", "Collapse node");
        this.putValue("MnemonicKey", 79);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    @Override
    public void setEnabled(Document document, TreeSelection selection, NodeBranchDataAdapter tableAdapter) {
        boolean oneNodeSelected = CollapseNodeAction.oneElementSelected(selection) && selection.containsType(Node.class);
        Node node = null;
        if (oneNodeSelected) {
            node = (Node)selection.first();
        }
        this.setEnabled(oneNodeSelected && (node.hasParent() || node.getChildren().size() == 1) && !node.isLeaf());
    }

    @Override
    protected void onActionPerformed(ActionEvent e, TreeInternalFrame frame) {
        CollapseNodeEdit edit = new CollapseNodeEdit(frame.getDocument(), (Node)frame.getTreeViewPanel().getSelection().first());
        frame.getDocument().executeEdit(edit);
        if (edit.hasWarnings()) {
            WikiHelpOptionPane.showMessageDialog((Component)MainFrame.getInstance(), (Object)edit.getWarningText(), (String)"Legend(s) reanchored", (int)2, (WikiHelp)Main.getInstance().getWikiHelp(), (int)25);
        }
    }
}

