/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.actions;

import info.bioinfweb.commons.swing.ExtendedAbstractAction;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JOptionPane;

public abstract class DocumentAction
extends ExtendedAbstractAction {
    public static final int MISSING_KEY_OUTPUT_CHARS_PER_LINE = 100;
    public static final int MAX_MISSING_KEY_OUTPUT_LINES = 10;
    private MainFrame mainFrame = null;

    public DocumentAction(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    protected abstract void onActionPerformed(ActionEvent var1, TreeInternalFrame var2);

    public abstract void setEnabled(Document var1, TreeSelection var2, NodeBranchDataAdapter var3);

    protected static boolean oneElementSelected(TreeSelection selection) {
        return selection != null && selection.size() == 1;
    }

    protected MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void actionPerformed(ActionEvent e) {
        TreeInternalFrame frame = this.mainFrame.getActiveTreeFrame();
        if (frame != null) {
            this.onActionPerformed(e, frame);
        } else {
            JOptionPane.showMessageDialog(frame, "There is no document selected.", "Error", 0);
        }
    }

    public static String createElementList(Collection<String> collection, boolean delimitElements) {
        return DocumentAction.createElementList(collection.iterator(), collection.size(), delimitElements);
    }

    public static String createElementList(Iterator<String> iterator, int size, boolean delimitElements) {
        StringBuffer result = new StringBuffer(1100);
        int charCount = 0;
        int lineCount = 0;
        int elementCount = 0;
        while (iterator.hasNext() && lineCount < 10) {
            String element = iterator.next();
            ++elementCount;
            if (delimitElements) {
                result.append("\"");
                result.append(element);
                result.append("\"");
            } else {
                result.append(element);
            }
            charCount += element.length();
            if (!iterator.hasNext()) continue;
            if (charCount >= 100) {
                result.append("\n");
                charCount = 0;
                ++lineCount;
                continue;
            }
            result.append(", ");
        }
        if (iterator.hasNext()) {
            result.append("... (" + (size - elementCount) + " more missing elements not shown here.)");
        }
        return result.toString();
    }
}

