/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.graphics.positionpaint.positiondata;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.format.DistanceValue;
import java.awt.Rectangle;

public class PositionData
implements Cloneable {
    private DistanceValue left = new DistanceValue(0.0f);
    private DistanceValue top = new DistanceValue(0.0f);
    private DistanceValue width = new DistanceValue(0.0f);
    private DistanceValue height = new DistanceValue(0.0f);

    public DistanceValue getHeight() {
        return this.height;
    }

    public DistanceValue getLeft() {
        return this.left;
    }

    public DistanceValue getTop() {
        return this.top;
    }

    public DistanceValue getWidth() {
        return this.width;
    }

    public float getRightInMillimeters() {
        return this.getLeft().getInMillimeters() + this.getWidth().getInMillimeters();
    }

    public float getRightInPixels(float pixelsPerMillimeter) {
        return this.getLeft().getInPixels(pixelsPerMillimeter) + this.getWidth().getInPixels(pixelsPerMillimeter);
    }

    public float getBottomInMillimeters() {
        return this.getTop().getInMillimeters() + this.getHeight().getInMillimeters();
    }

    public float getBottomInPixels(float pixelsPerMillimeter) {
        return this.getTop().getInPixels(pixelsPerMillimeter) + this.getHeight().getInPixels(pixelsPerMillimeter);
    }

    public float getCenterXInMillimeters() {
        return this.getLeft().getInMillimeters() + 0.5f * this.getWidth().getInMillimeters();
    }

    public float getCenterXInPixels(float pixelsPerMillimeter) {
        return this.getLeft().getInPixels(pixelsPerMillimeter) + 0.5f * this.getWidth().getInPixels(pixelsPerMillimeter);
    }

    public float getCenterYInMillimeters() {
        return this.getTop().getInMillimeters() + 0.5f * this.getHeight().getInMillimeters();
    }

    public float getCenterYInPixels(float pixelsPerMillimeter) {
        return this.getTop().getInPixels(pixelsPerMillimeter) + 0.5f * this.getHeight().getInPixels(pixelsPerMillimeter);
    }

    public boolean contains(DistanceValue x, DistanceValue y, float margin) {
        return this.contains(x.getInMillimeters(), y.getInMillimeters(), margin);
    }

    public boolean contains(float x, float y, float margin) {
        return Math2.isBetween(x, this.getLeft().getInMillimeters() - margin, this.getRightInMillimeters() + margin) && Math2.isBetween(y, this.getTop().getInMillimeters() - margin, this.getBottomInMillimeters() + margin);
    }

    public Rectangle toRect(float pixelsPerMillimeter) {
        Rectangle result = new Rectangle(this.getLeft().getRoundedInPixels(pixelsPerMillimeter), this.getTop().getRoundedInPixels(pixelsPerMillimeter), this.getWidth().getRoundedInPixels(pixelsPerMillimeter), this.getHeight().getRoundedInPixels(pixelsPerMillimeter));
        return result;
    }

    public void assignPositionData(PositionData other) {
        this.getLeft().assign(other.getLeft());
        this.getTop().assign(other.getTop());
        this.getWidth().assign(other.getWidth());
        this.getHeight().assign(other.getHeight());
    }

    public PositionData clone() throws CloneNotSupportedException {
        return (PositionData)super.clone();
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[left=" + this.getLeft() + ",top=" + this.getTop() + ",width=" + this.getWidth() + ",height=" + this.getHeight() + "]";
    }
}

