/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.graphics.positionpaint.label.icons;

import info.bioinfweb.treegraph.document.format.IconLabelFormats;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.LabelIcon;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.ShapeLabelIcon;
import java.awt.Shape;
import java.awt.geom.Path2D;

public class TiltedHexagonIcon
extends ShapeLabelIcon
implements LabelIcon {
    @Override
    public Shape getShape(float x, float y, IconLabelFormats formats, float pixelsPerMillimeter) {
        float lineWidth = formats.getLineWidth().getInPixels(pixelsPerMillimeter);
        x += 0.5f * lineWidth;
        y += 0.5f * lineWidth;
        float width = formats.getWidth().getInPixels(pixelsPerMillimeter) - lineWidth;
        float edgeLengthX = width / 2.0f;
        float height = formats.getHeight().getInPixels(pixelsPerMillimeter) - lineWidth;
        float cornerLengthY = height / 4.0f;
        float edgeLengthY = height / 2.0f;
        Path2D.Float result = new Path2D.Float();
        ((Path2D)result).moveTo(x + edgeLengthX, y);
        ((Path2D)result).lineTo(x + width, y + cornerLengthY);
        ((Path2D)result).lineTo(x + width, y + edgeLengthY + cornerLengthY);
        ((Path2D)result).lineTo(x + edgeLengthX, y + height);
        ((Path2D)result).lineTo(x, y + edgeLengthY + cornerLengthY);
        ((Path2D)result).lineTo(x, y + cornerLengthY);
        result.closePath();
        return result;
    }

    @Override
    public String id() {
        return "Tilted hexagon";
    }
}

