/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.graphics.positionpaint.label.icons;

import info.bioinfweb.treegraph.document.format.IconLabelFormats;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.LabelIcon;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.ShapeLabelIcon;
import java.awt.Shape;
import java.awt.geom.Path2D;

public class StarIcon
extends ShapeLabelIcon
implements LabelIcon {
    public static final String ID = "Star";
    public static final double RAY_ANGLE = 1.2566370614359172;
    public static final float SIN_RAY_72 = (float)Math.sin(1.2566370614359172);
    public static final float COS_RAY_72 = (float)Math.cos(1.2566370614359172);
    public static final float SIN_RAY_36 = (float)Math.sin(0.6283185307179586);
    public static final float COS_RAY_36 = (float)Math.cos(0.6283185307179586);
    public static final float LENGTH_BETWEEN_RAYS_FACTOR = 0.33333334f;

    @Override
    public Shape getShape(float x, float y, IconLabelFormats formats, float pixelsPerMillimeter) {
        float height;
        float lineWidth = formats.getLineWidth().getInPixels(pixelsPerMillimeter);
        x += lineWidth;
        y += lineWidth;
        float width = height = formats.getHeight().getInPixels(pixelsPerMillimeter) - 2.0f * lineWidth;
        float halfWidth = 0.5f * width;
        float widthFactor = (formats.getWidth().getInPixels(pixelsPerMillimeter) - 2.0f * lineWidth) / height;
        float rayLength = height / (1.0f + COS_RAY_36);
        float betweenRayLength = 0.33333334f * rayLength;
        float halfUpperRayWidth = SIN_RAY_36 * betweenRayLength;
        float upperRayHeight = rayLength - COS_RAY_36 * betweenRayLength;
        float middleRaysApexY = rayLength - COS_RAY_72 * rayLength;
        float halfMiddleStarWidth = SIN_RAY_72 * betweenRayLength;
        float middleStarY = rayLength + COS_RAY_72 * betweenRayLength;
        float halfBottomRayDistance = SIN_RAY_36 * (height - rayLength);
        Path2D.Float result = new Path2D.Float();
        ((Path2D)result).moveTo(x + widthFactor * halfWidth, y);
        ((Path2D)result).lineTo(x + widthFactor * (halfWidth + halfUpperRayWidth), y + upperRayHeight);
        ((Path2D)result).lineTo(x + widthFactor * width, y + middleRaysApexY);
        ((Path2D)result).lineTo(x + widthFactor * (halfWidth + halfMiddleStarWidth), y + middleStarY);
        ((Path2D)result).lineTo(x + widthFactor * (halfWidth + halfBottomRayDistance), y + height);
        ((Path2D)result).lineTo(x + widthFactor * halfWidth, y + rayLength + betweenRayLength);
        ((Path2D)result).lineTo(x + widthFactor * (halfWidth - halfBottomRayDistance), y + height);
        ((Path2D)result).lineTo(x + widthFactor * (halfWidth - halfMiddleStarWidth), y + middleStarY);
        ((Path2D)result).lineTo(x, y + middleRaysApexY);
        ((Path2D)result).lineTo(x + widthFactor * (halfWidth - halfUpperRayWidth), y + upperRayHeight);
        result.closePath();
        return result;
    }

    @Override
    public String id() {
        return ID;
    }
}

