/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.graphics.positionpaint.label.icons;

import info.bioinfweb.treegraph.document.format.IconLabelFormats;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.LabelIcon;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.ShapeLabelIcon;
import java.awt.Shape;
import java.awt.geom.Path2D;

public class OctagonIcon
extends ShapeLabelIcon
implements LabelIcon {
    public static final float SQRT_OF_2 = (float)Math.sqrt(2.0);

    @Override
    public Shape getShape(float x, float y, IconLabelFormats formats, float pixelsPerMillimeter) {
        float lineWidth = formats.getLineWidth().getInPixels(pixelsPerMillimeter);
        x += 0.5f * lineWidth;
        y += 0.5f * lineWidth;
        float width = formats.getWidth().getInPixels(pixelsPerMillimeter) - lineWidth;
        float cornerLengthX = width / (2.0f + SQRT_OF_2);
        float edgeLengthX = SQRT_OF_2 * cornerLengthX;
        float height = formats.getHeight().getInPixels(pixelsPerMillimeter) - lineWidth;
        float cornerLengthY = height / (2.0f + SQRT_OF_2);
        float edgeLengthY = SQRT_OF_2 * cornerLengthY;
        Path2D.Float result = new Path2D.Float();
        ((Path2D)result).moveTo(x + cornerLengthX, y);
        ((Path2D)result).lineTo(x + cornerLengthX + edgeLengthX, y);
        ((Path2D)result).lineTo(x + width, y + cornerLengthY);
        ((Path2D)result).lineTo(x + width, y + cornerLengthY + edgeLengthY);
        ((Path2D)result).lineTo(x + cornerLengthX + edgeLengthX, y + height);
        ((Path2D)result).lineTo(x + cornerLengthX, y + height);
        ((Path2D)result).lineTo(x, y + edgeLengthY + cornerLengthY);
        ((Path2D)result).lineTo(x, y + cornerLengthY);
        result.closePath();
        return result;
    }

    @Override
    public String id() {
        return "Octagon";
    }
}

