/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.graphics.positionpaint.label.icons;

import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.CrossIcon;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.EllipseIcon;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.HexagonIcon;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.LabelIcon;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.OctagonIcon;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.RectangleIcon;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.RoundRectangleIcon;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.StarIcon;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.TiltedCrossIcon;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.TiltedHexagonIcon;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.TriangleIcon;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.UnknownIcon;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class LabelIconMap {
    public static final LabelIcon UNKNOWN_ICON = new UnknownIcon();
    private static LabelIconMap firstInstance = null;
    private Map<String, LabelIcon> map = new HashMap<String, LabelIcon>();

    private LabelIconMap() {
        this.fill();
    }

    private void put(LabelIcon icon) {
        this.map.put(icon.id(), icon);
    }

    private void fill() {
        this.put(new TriangleIcon());
        this.put(new RectangleIcon());
        this.put(new RoundRectangleIcon());
        this.put(new EllipseIcon());
        this.put(new HexagonIcon());
        this.put(new TiltedHexagonIcon());
        this.put(new OctagonIcon());
        this.put(new CrossIcon());
        this.put(new TiltedCrossIcon());
        this.put(new StarIcon());
    }

    public static LabelIconMap getInstance() {
        if (firstInstance == null) {
            firstInstance = new LabelIconMap();
        }
        return firstInstance;
    }

    public String getDefaultID() {
        return "Star";
    }

    public LabelIcon get(String id) {
        LabelIcon result = this.map.get(id);
        if (result == null) {
            result = UNKNOWN_ICON;
        }
        return result;
    }

    public int size() {
        return this.map.size();
    }

    public Collection<LabelIcon> values() {
        return this.map.values();
    }
}

