/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.graphics.positionpaint.label.icons;

import info.bioinfweb.treegraph.document.format.IconLabelFormats;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.LabelIcon;
import info.bioinfweb.treegraph.graphics.positionpaint.label.icons.ShapeLabelIcon;
import java.awt.Shape;
import java.awt.geom.Path2D;

public class HexagonIcon
extends ShapeLabelIcon
implements LabelIcon {
    @Override
    public Shape getShape(float x, float y, IconLabelFormats formats, float pixelsPerMillimeter) {
        float lineWidth = formats.getLineWidth().getInPixels(pixelsPerMillimeter);
        x += 0.5f * lineWidth;
        y += 0.5f * lineWidth;
        float width = formats.getWidth().getInPixels(pixelsPerMillimeter) - lineWidth;
        float cornerLengthX = width / 4.0f;
        float edgeLengthX = width / 2.0f;
        float height = formats.getHeight().getInPixels(pixelsPerMillimeter) - lineWidth;
        float edgeLengthY = height / 2.0f;
        Path2D.Float result = new Path2D.Float();
        ((Path2D)result).moveTo(x + cornerLengthX, y);
        ((Path2D)result).lineTo(x + cornerLengthX + edgeLengthX, y);
        ((Path2D)result).lineTo(x + width, y + edgeLengthY);
        ((Path2D)result).lineTo(x + cornerLengthX + edgeLengthX, y + height);
        ((Path2D)result).lineTo(x + cornerLengthX, y + height);
        ((Path2D)result).lineTo(x, y + edgeLengthY);
        result.closePath();
        return result;
    }

    @Override
    public String id() {
        return "Hexagon";
    }
}

